/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.azurune.runiclib.RunicLib;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.util.TriState;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamEntity;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;

public class RotbulbCropBlock
extends PitcherCropBlock
implements BonemealableBlock {
    public RotbulbCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)AGE) >= 4;
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.isFaceSturdy(getter, pos.below(), Direction.UP);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getType().is(EntityTypeTags.UNDEAD)) {
            living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300, 0));
            living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 300, 0));
        }
        super.entityInside(state, level, pos, entity);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        TriState soilDecision = level.getBlockState(pos.below()).canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state);
        return RotbulbCropBlock.isLower(state) && !RotbulbCropBlock.sufficientLight(level, pos) ? soilDecision.isTrue() : super.canSurvive(state, level, pos);
    }

    private void spawnMonsterYam(ServerLevel level, BlockPos pos) {
        if (level.getLevel().getDifficulty() == Difficulty.PEACEFUL) {
            ResourceLocation lootTableId = RunicLib.customid((String)"dungeonsdelight", (String)"entities/monster_yam");
            LootParams.Builder builder = new LootParams.Builder(level).withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(pos));
            ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTableId);
            LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableKey);
            ObjectArrayList lootData = lootTable.getRandomItems(builder.create(LootContextParamSets.EMPTY), level.random.nextLong());
            if (!lootData.isEmpty()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)((double)pos.getY() - 0.6), (double)pos.getZ(), (ItemStack)((ItemStack)lootData.get(level.random.nextInt(lootData.size()))));
            }
        } else {
            MonsterYamEntity monsterYam = (MonsterYamEntity)DDEntities.MONSTER_YAM.get().create((Level)level);
            if (monsterYam != null) {
                monsterYam.moveTo(pos.getX(), pos.getY(), pos.getZ(), 0.0f, 0.0f);
                level.addFreshEntity((Entity)monsterYam);
                monsterYam.spawnAnim();
                level.playSound((Entity)monsterYam, pos, DDSounds.MONSTER_YAM_AMBIENT.get(), SoundSource.HOSTILE, 2.0f, -1.0f);
            }
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack stack) {
        super.playerDestroy(level, player, pos, state, entity, stack);
        if (!level.isClientSide && this.isMaxAge(state) && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            this.spawnMonsterYam((ServerLevel)level, pos);
        }
    }

    private static boolean canGrowInto(LevelReader reader, BlockPos pos) {
        BlockState blockstate = reader.getBlockState(pos);
        return blockstate.isAir() || blockstate.is(DDBlocks.ROTBULB_CROP.get());
    }

    private static boolean sufficientLight(LevelReader reader, BlockPos pos) {
        return reader.getRawBrightness(pos, 0) <= 8 || !reader.canSeeSky(pos);
    }

    private static boolean isLower(BlockState state) {
        return state.is(DDBlocks.ROTBULB_CROP.get()) && state.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    private static boolean isUpper(BlockState state) {
        return state.is(DDBlocks.ROTBULB_CROP.get()) && state.getValue((Property)HALF) == DoubleBlockHalf.UPPER;
    }

    private boolean canGrow(LevelReader reader, BlockPos pos, BlockState state, int i) {
        return !this.isMaxAge(state) && RotbulbCropBlock.sufficientLight(reader, pos) && (i < 3 || RotbulbCropBlock.canGrowInto(reader, pos.above()));
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader reader, BlockPos pos, BlockState state) {
        if (RotbulbCropBlock.isLower(state)) {
            return new PosAndState(pos, state);
        }
        BlockPos blockpos = pos.below();
        BlockState blockstate = reader.getBlockState(blockpos);
        return RotbulbCropBlock.isLower(blockstate) ? new PosAndState(blockpos, blockstate) : null;
    }

    public boolean isValidBonemealTarget(LevelReader reader, BlockPos pos, BlockState state, boolean b) {
        PosAndState cropStatePos = this.getLowerHalf(reader, pos, state);
        return cropStatePos != null && this.canGrow(reader, cropStatePos.pos, cropStatePos.state, (Integer)cropStatePos.state.getValue((Property)AGE) + 1);
    }

    public boolean isBonemealSuccess(Level level, RandomSource source, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource source, BlockPos pos, BlockState state) {
        PosAndState cropStatePos = this.getLowerHalf((LevelReader)level, pos, state);
        if (cropStatePos != null) {
            this.grow(level, cropStatePos.state, cropStatePos.pos, 1);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        boolean flag;
        float f = RotbulbCropBlock.getGrowthSpeed(state, (BlockGetter)level, pos);
        boolean bl = flag = source.nextInt((int)(25.0f / f) + 1) == 0;
        if (flag) {
            this.grow(level, state, pos, 1);
        }
    }

    private void grow(ServerLevel level, BlockState state, BlockPos pos, int i1) {
        int i = Math.min((Integer)state.getValue((Property)AGE) + i1, 4);
        if (this.canGrow((LevelReader)level, pos, state, i)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
            if (i >= 3) {
                BlockPos blockpos = pos.above();
                level.setBlock(blockpos, RotbulbCropBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)pos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER))), 3);
            }
        }
    }

    public static float getGrowthSpeed(BlockState blockState, BlockGetter getter, BlockPos pos) {
        boolean flag1;
        Block myself = blockState.getBlock();
        float f = 0.5f;
        BlockPos blockpos = pos.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.5f;
                BlockState blockstate = getter.getBlockState(blockpos.offset(i, 0, j));
                if (blockstate.is(DDTags.BlockT.ROTBULB_CROP_GROWS_FASTER)) {
                    f1 = 1.5f;
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.north();
        BlockPos blockpos2 = pos.south();
        BlockPos blockpos3 = pos.west();
        BlockPos blockpos4 = pos.east();
        boolean flag = getter.getBlockState(blockpos3).is(myself) || getter.getBlockState(blockpos4).is(myself);
        boolean bl = flag1 = getter.getBlockState(blockpos1).is(myself) || getter.getBlockState(blockpos2).is(myself);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = getter.getBlockState(blockpos3.north()).is(myself) || getter.getBlockState(blockpos4.north()).is(myself) || getter.getBlockState(blockpos4.south()).is(myself) || getter.getBlockState(blockpos3.south()).is(myself);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    record PosAndState(BlockPos pos, BlockState state) {
    }
}

