/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WormrootsStalkBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    protected static final VoxelShape BASE_SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
    protected static final VoxelShape UP_SHAPE = Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape DOWN_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static Map<Direction, BooleanProperty> DIRECTION_TO_PROPERTY = new HashMap<Direction, BooleanProperty>();
    public static Map<Direction, VoxelShape> DIRECTION_TO_SHAPE = new HashMap<Direction, VoxelShape>();

    public WormrootsStalkBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
        DIRECTION_TO_PROPERTY.put(Direction.NORTH, NORTH);
        DIRECTION_TO_PROPERTY.put(Direction.EAST, EAST);
        DIRECTION_TO_PROPERTY.put(Direction.SOUTH, SOUTH);
        DIRECTION_TO_PROPERTY.put(Direction.WEST, WEST);
        DIRECTION_TO_PROPERTY.put(Direction.UP, UP);
        DIRECTION_TO_PROPERTY.put(Direction.DOWN, DOWN);
        DIRECTION_TO_SHAPE.put(Direction.NORTH, NORTH_SHAPE);
        DIRECTION_TO_SHAPE.put(Direction.EAST, EAST_SHAPE);
        DIRECTION_TO_SHAPE.put(Direction.SOUTH, SOUTH_SHAPE);
        DIRECTION_TO_SHAPE.put(Direction.WEST, WEST_SHAPE);
        DIRECTION_TO_SHAPE.put(Direction.UP, UP_SHAPE);
        DIRECTION_TO_SHAPE.put(Direction.DOWN, DOWN_SHAPE);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape axisShape = BASE_SHAPE;
        ArrayList<VoxelShape> additionalShapes = new ArrayList<VoxelShape>(List.of());
        for (Direction direction : UPDATE_SHAPE_ORDER) {
            if (state.getValue((Property)AXIS) == Direction.Axis.Y) {
                xor = (Boolean)state.getValue((Property)UP) ^ (Boolean)state.getValue((Property)DOWN);
                if (!((Boolean)state.getValue((Property)UP)).booleanValue() && !((Boolean)state.getValue((Property)DOWN)).booleanValue() || xor && !((Boolean)state.getValue((Property)NORTH)).booleanValue() && !((Boolean)state.getValue((Property)EAST)).booleanValue() && !((Boolean)state.getValue((Property)SOUTH)).booleanValue() && !((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                    additionalShapes.add(UP_SHAPE);
                    additionalShapes.add(DOWN_SHAPE);
                }
            } else if (state.getValue((Property)AXIS) == Direction.Axis.X) {
                xor = (Boolean)state.getValue((Property)EAST) ^ (Boolean)state.getValue((Property)WEST);
                if (!((Boolean)state.getValue((Property)EAST)).booleanValue() && !((Boolean)state.getValue((Property)WEST)).booleanValue() || xor && !((Boolean)state.getValue((Property)NORTH)).booleanValue() && !((Boolean)state.getValue((Property)UP)).booleanValue() && !((Boolean)state.getValue((Property)SOUTH)).booleanValue() && !((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
                    additionalShapes.add(EAST_SHAPE);
                    additionalShapes.add(WEST_SHAPE);
                }
            } else if (state.getValue((Property)AXIS) == Direction.Axis.Z) {
                xor = (Boolean)state.getValue((Property)NORTH) ^ (Boolean)state.getValue((Property)SOUTH);
                if (!((Boolean)state.getValue((Property)NORTH)).booleanValue() && !((Boolean)state.getValue((Property)SOUTH)).booleanValue() || xor && !((Boolean)state.getValue((Property)EAST)).booleanValue() && !((Boolean)state.getValue((Property)UP)).booleanValue() && !((Boolean)state.getValue((Property)WEST)).booleanValue() && !((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
                    additionalShapes.add(NORTH_SHAPE);
                    additionalShapes.add(SOUTH_SHAPE);
                }
            }
            if (!((Boolean)state.getValue((Property)DIRECTION_TO_PROPERTY.get(direction))).booleanValue()) continue;
            additionalShapes.add(DIRECTION_TO_SHAPE.get(direction));
        }
        for (int i = 0; i < additionalShapes.size(); ++i) {
            axisShape = Shapes.or((VoxelShape)axisShape, (VoxelShape)((VoxelShape)additionalShapes.get(i)));
        }
        return axisShape;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        HashMap<Direction, Boolean> directionMap = new HashMap<Direction, Boolean>();
        for (Direction direction : UPDATE_SHAPE_ORDER) {
            BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos().relative(direction));
            if (blockState.is((Block)this) && !((Boolean)blockState.getValue((Property)DIRECTION_TO_PROPERTY.get(direction.getOpposite()))).booleanValue()) {
                directionMap.put(direction, true);
                continue;
            }
            directionMap.put(direction, false);
        }
        ctx.getLevel().scheduleTick(ctx.getClickedPos(), (Block)this, 1);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER))).setValue((Property)NORTH, (Comparable)((Boolean)directionMap.get(Direction.NORTH)))).setValue((Property)EAST, (Comparable)((Boolean)directionMap.get(Direction.EAST)))).setValue((Property)SOUTH, (Comparable)((Boolean)directionMap.get(Direction.SOUTH)))).setValue((Property)WEST, (Comparable)((Boolean)directionMap.get(Direction.WEST)))).setValue((Property)UP, (Comparable)((Boolean)directionMap.get(Direction.UP)))).setValue((Property)DOWN, (Comparable)((Boolean)directionMap.get(Direction.DOWN)));
    }

    public BlockState updateShape(BlockState state, Direction unusedDir, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return this.updateState(world, pos, state);
    }

    private BlockState updateState(LevelAccessor world, BlockPos pos, BlockState state) {
        HashMap<Direction, Boolean> directionMap = new HashMap<Direction, Boolean>();
        for (Direction direction : UPDATE_SHAPE_ORDER) {
            BlockState blockState = world.getBlockState(pos.relative(direction));
            directionMap.put(direction, blockState.is((Block)this));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)directionMap.get(Direction.NORTH)))).setValue((Property)EAST, (Comparable)((Boolean)directionMap.get(Direction.EAST)))).setValue((Property)SOUTH, (Comparable)((Boolean)directionMap.get(Direction.SOUTH)))).setValue((Property)WEST, (Comparable)((Boolean)directionMap.get(Direction.WEST)))).setValue((Property)UP, (Comparable)((Boolean)directionMap.get(Direction.UP)))).setValue((Property)DOWN, (Comparable)((Boolean)directionMap.get(Direction.DOWN)));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.updateState((LevelAccessor)level, pos, state);
        super.tick(state, level, pos, random);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, AXIS, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        for (Direction direction : Direction.values()) {
            BlockPos targetPos = blockPos.relative(direction);
            BlockState state = level.getBlockState(targetPos);
            if (!state.isAir() && !state.canBeReplaced()) continue;
            return true;
        }
        return false;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState blockState) {
        ArrayList<Direction> allDirections = new ArrayList<Direction>(List.of(Direction.values()));
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        for (Direction direction : allDirections) {
            BlockPos targetPos = pos.relative(direction);
            BlockState state = level.getBlockState(targetPos);
            if (!state.isAir() && !state.canBeReplaced()) continue;
            validDirections.add(direction);
        }
        if (!validDirections.isEmpty()) {
            this.growWormrootStalks(level, pos, (Direction)validDirections.get(0));
            ArrayList otherDirections = new ArrayList(validDirections);
            otherDirections.remove(validDirections.get(0));
            Collections.shuffle(otherDirections, new Random(random.nextLong()));
            List skippedDirections = otherDirections.subList(0, Math.min(3, otherDirections.size()));
            for (Direction dir : otherDirections) {
                if (skippedDirections.contains(dir) && random.nextFloat() < 0.6f) continue;
                this.growWormrootStalks(level, pos, dir);
            }
        }
    }

    private void growWormrootStalks(ServerLevel level, BlockPos pos, Direction direction) {
        if (level.getBlockState(pos.relative(direction)).canBeReplaced()) {
            BlockState newState = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)direction.getAxis())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.relative(direction)).getType() == Fluids.WATER))).setValue((Property)DIRECTION_TO_PROPERTY.get(direction.getOpposite()), (Comparable)Boolean.valueOf(true));
            newState = this.updateState((LevelAccessor)level, pos.relative(direction), newState);
            level.setBlock(pos.relative(direction), newState, 3);
            level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHORUS_FLOWER_GROW, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

