/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.yirmiri.dungeonsdelight.common.block.entity.ItemGrateTooltip;
import net.yirmiri.dungeonsdelight.core.registry.DDBlockEntities;

public class ItemGrateBlockEntity
extends BlockEntity
implements ItemGrateTooltip {
    private ItemStack stack = ItemStack.EMPTY;
    private float rotation;
    private boolean waxed;
    private boolean fast;
    private boolean large;

    public ItemGrateBlockEntity(BlockPos pos, BlockState state) {
        super(DDBlockEntities.ITEM_GRATE.get(), pos, state);
    }

    public void insertItem(Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        if (!held.isEmpty() && this.stack.isEmpty()) {
            this.stack = held.split(1);
            this.update();
        }
    }

    public void takeItem(Player player) {
        if (!this.stack.isEmpty()) {
            player.addItem(this.stack.copy());
            this.stack = ItemStack.EMPTY;
            this.update();
        }
    }

    public void dropItem(Level level, BlockPos pos) {
        if (!level.isClientSide && !this.stack.isEmpty()) {
            ItemStack drop = this.stack.copy();
            this.stack = ItemStack.EMPTY;
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
        }
    }

    public void tick(BlockPos pos) {
        RandomSource randomsource;
        if (!this.isWaxed()) {
            this.rotation += 2.0f;
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
            }
            this.setChanged();
        }
        if (!this.canInsert() && (randomsource = this.level.getRandom()).nextBoolean()) {
            double d0 = (double)pos.getX() + randomsource.nextDouble();
            double d1 = (double)pos.getY() + randomsource.nextDouble();
            double d2 = (double)pos.getZ() + randomsource.nextDouble();
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public float getRotationSpeed(float partialTicks) {
        float baseRotation = this.rotation + partialTicks * 2.0f;
        return this.fast ? baseRotation * 2.0f : baseRotation;
    }

    public float getRotation() {
        return this.rotation;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean canInsert() {
        return this.stack == ItemStack.EMPTY;
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public boolean isFast() {
        return this.fast;
    }

    public boolean isLarge() {
        return this.large;
    }

    public float getRenderScale() {
        if (this.large) {
            return 1.5f;
        }
        return 1.0f;
    }

    public void setWaxed(boolean newValue) {
        this.waxed = newValue;
        this.update();
    }

    public void setFast(boolean newValue) {
        this.fast = newValue;
        this.update();
    }

    public void setLarge(boolean newValue) {
        this.large = newValue;
        this.update();
    }

    public void update() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putFloat("rotation", this.rotation);
        tag.putBoolean("waxed", this.waxed);
        tag.putBoolean("fast", this.fast);
        tag.putBoolean("large", this.large);
        if (!this.stack.isEmpty()) {
            tag.put("item", this.stack.save(registries));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.rotation = tag.getFloat("rotation");
        this.waxed = tag.getBoolean("waxed");
        this.fast = tag.getBoolean("fast");
        this.large = tag.getBoolean("large");
        this.stack = tag.contains("item") ? ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("item")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

