/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.yirmiri.dungeonsdelight.common.block.entity.ItemGrateBlockEntity;
import net.yirmiri.dungeonsdelight.common.util.DDProperties;

public class ItemGrateBlockEntityRenderer
implements BlockEntityRenderer<ItemGrateBlockEntity> {
    public ItemGrateBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ItemGrateBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemStack stack = blockEntity.getStack();
        if (!stack.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.385, 0.5);
            if (Minecraft.renderNames() && stack.has(DataComponents.CUSTOM_NAME) && Minecraft.getInstance().getEntityRenderDispatcher().distanceToSqr((double)blockEntity.getBlockPos().getX() + 0.5, (double)blockEntity.getBlockPos().getY() + 0.5, (double)blockEntity.getBlockPos().getZ() + 0.5) < 324.0) {
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.875f, 0.0f);
                poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
                poseStack.scale(0.025f, -0.025f, -0.025f);
                Minecraft.getInstance().font.drawInBatch(blockEntity.getStack().getHoverName(), (float)(-Minecraft.getInstance().font.width((FormattedText)blockEntity.getStack().getHoverName())) / 2.0f, 0.0f, this.probablysomethingbettericando(stack).intValue(), false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, (int)Minecraft.getInstance().options.getBackgroundOpacity(0.25f), packedLight);
                poseStack.popPose();
            }
            poseStack.scale(blockEntity.getRenderScale(), blockEntity.getRenderScale(), blockEntity.getRenderScale());
            BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(stack, blockEntity.getLevel(), null, 0);
            if (!blockEntity.isWaxed()) {
                poseStack.mulPose(Axis.YP.rotationDegrees(blockEntity.getRotationSpeed(partialTick)));
            } else {
                poseStack.mulPose(Axis.YP.rotationDegrees(blockEntity.getRotation()));
            }
            Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.GROUND, false, poseStack, buffer, packedLight, packedOverlay, model);
            poseStack.popPose();
        }
    }

    private Integer probablysomethingbettericando(ItemStack stack) {
        if (stack.getRarity().ordinal() <= 3) {
            return stack.getRarity().color().getColor();
        }
        if (stack.getRarity() == DDProperties.MONSTER) {
            return 13137346;
        }
        return -1;
    }
}

