/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block.monster_pot;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.yirmiri.dungeonsdelight.common.block.monster_pot.MonsterPotBlockEntity;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDBlockEntities;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.state.CookingPotSupport;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.MathUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class MonsterPotBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final MapCodec<MonsterPotBlock> CODEC = MonsterPotBlock.simpleCodec(MonsterPotBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<CookingPotSupport> SUPPORT = EnumProperty.create((String)"support", CookingPotSupport.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = Shapes.or((VoxelShape)SHAPE, (VoxelShape)Block.box((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public MonsterPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SUPPORT, (Comparable)CookingPotSupport.NONE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (heldStack.isEmpty() && player.isShiftKeyDown()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(SUPPORT, (Comparable)(((CookingPotSupport)state.getValue(SUPPORT)).equals((Object)CookingPotSupport.HANDLE) ? this.getTrayState((LevelAccessor)level, pos) : CookingPotSupport.HANDLE)));
            level.playSound(null, pos, SoundEvents.LANTERN_PLACE, SoundSource.BLOCKS, 0.7f, 1.0f);
        } else if (!level.isClientSide) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MonsterPotBlockEntity) {
                MonsterPotBlockEntity potEntity = (MonsterPotBlockEntity)blockEntity;
                ItemStack servingStack = potEntity.useHeldItemOnMeal(heldStack);
                if (!servingStack.isEmpty()) {
                    if (!player.getInventory().add(servingStack)) {
                        player.drop(servingStack, false);
                    }
                    level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    player.openMenu((MenuProvider)potEntity, pos);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((CookingPotSupport)state.getValue(SUPPORT)).equals((Object)CookingPotSupport.TRAY) ? SHAPE_WITH_TRAY : SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        FluidState fluid = level.getFluidState(pos);
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        if (context.getClickedFace().equals((Object)Direction.DOWN)) {
            return (BlockState)state.setValue(SUPPORT, (Comparable)CookingPotSupport.HANDLE);
        }
        return (BlockState)state.setValue(SUPPORT, (Comparable)this.getTrayState((LevelAccessor)level, pos));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (facing.getAxis().equals((Object)Direction.Axis.Y) && !((CookingPotSupport)state.getValue(SUPPORT)).equals((Object)CookingPotSupport.HANDLE)) {
            return (BlockState)state.setValue(SUPPORT, (Comparable)this.getTrayState(level, currentPos));
        }
        return state;
    }

    private CookingPotSupport getTrayState(LevelAccessor level, BlockPos pos) {
        return level.getBlockState(pos.below()).is(DDTags.BlockT.MONSTER_TRAY_HEAT_SOURCES) ? CookingPotSupport.TRAY : CookingPotSupport.NONE;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        Optional cookingPot = level.getBlockEntity(pos, DDBlockEntities.MONSTER_COOKING_POT.get());
        if (cookingPot.isPresent()) {
            stack = ((MonsterPotBlockEntity)cookingPot.get()).getAsItem();
        }
        return stack;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof MonsterPotBlockEntity) {
                MonsterPotBlockEntity potEntity = (MonsterPotBlockEntity)tileEntity;
                Containers.dropContents((Level)level, (BlockPos)pos, potEntity.getDroppableInventory());
                potEntity.getUsedRecipesAndPopExperience(level, Vec3.atCenterOf((Vec3i)pos));
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, SUPPORT, WATERLOGGED});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, ctx, tooltip, tooltipFlag);
        ItemStack mealStack = MonsterPotBlockEntity.getMealFromItem(stack);
        if (!mealStack.isEmpty()) {
            MutableComponent textServingsOf = mealStack.getCount() == 1 ? TextUtils.getTranslation((String)"tooltip.cooking_pot.single_serving", (Object[])new Object[0]) : TextUtils.getTranslation((String)"tooltip.cooking_pot.many_servings", (Object[])new Object[]{mealStack.getCount()});
            tooltip.add((Component)textServingsOf.withStyle(ChatFormatting.GRAY));
            MutableComponent textMealName = mealStack.getHoverName().copy();
            tooltip.add((Component)textMealName.withStyle(mealStack.getRarity().getStyleModifier()));
        } else {
            MutableComponent textServingsOf = TextUtils.getTranslation((String)"tooltip.cooking_pot.empty", (Object[])new Object[0]);
            tooltip.add((Component)textServingsOf.withStyle(ChatFormatting.GRAY));
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        MonsterPotBlockEntity potEntity;
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof MonsterPotBlockEntity && (potEntity = (MonsterPotBlockEntity)tileEntity).isHeated()) {
            SoundEvent boilSound = !potEntity.getMeal().isEmpty() ? (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL_SOUP.get() : (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL.get();
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            if (random.nextInt(10) == 0) {
                level.playLocalSound(x, y, z, boilSound, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof MonsterPotBlockEntity) {
            MonsterPotBlockEntity potEntity = (MonsterPotBlockEntity)tileEntity;
            ItemStackHandler inventory = potEntity.getInventory();
            return MathUtils.calcRedstoneFromItemHandler((IItemHandlerModifiable)inventory);
        }
        return 0;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return DDBlockEntities.MONSTER_COOKING_POT.get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide) {
            return MonsterPotBlock.createTickerHelper(type, DDBlockEntities.MONSTER_COOKING_POT.get(), MonsterPotBlockEntity::animationTick);
        }
        return MonsterPotBlock.createTickerHelper(type, DDBlockEntities.MONSTER_COOKING_POT.get(), MonsterPotBlockEntity::cookingTick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }
}

