/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.misc;

import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import org.joml.Vector3fc;

public class CleaverEntity
extends AbstractArrow {
    public static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(CleaverEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(CleaverEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public ItemStack cleaverItem;
    private double damage = 0.0;
    public boolean canBypassCooldowns = false;
    public int despawnTime = 200;
    public boolean spinning = true;
    public boolean hasSetCooldown = false;
    public float ricochetsPitch = 1.0f;
    public int ricochetsLeft = 0;
    public int serratedLevel = 0;
    public int soundTickCounter = 0;
    public boolean fullyCharged = false;
    public boolean longCooldown;
    public Direction blockSide = null;
    public float embeddedRotOffset = 0.0f;

    public CleaverEntity(EntityType<? extends CleaverEntity> type, Level level) {
        super(type, level);
    }

    public CleaverEntity(Level level, LivingEntity shooter, ItemStack pickupItemStack) {
        super(DDEntities.CLEAVER.get(), shooter, level, pickupItemStack, null);
        this.cleaverItem = this.getCleaverStack();
        this.cleaverItem = this.getCleaverStack().copy();
        this.setOwner((Entity)shooter);
        this.entityData.set(ID_FOIL, (Object)pickupItemStack.hasFoil());
    }

    public void setItem(ItemStack stack) {
        this.getEntityData().set(DATA_ITEM_STACK, (Object)stack.copyWithCount(1));
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM_STACK);
    }

    public ItemStack getCleaverStack() {
        ItemStack stack = this.getItemRaw();
        return stack.isEmpty() ? new ItemStack((ItemLike)DDItems.FLINT_CLEAVER.get()) : stack;
    }

    public ItemStack getPickupItem() {
        return this.getCleaverStack();
    }

    public ItemStack getWeaponItem() {
        return this.getCleaverStack();
    }

    protected ItemStack getDefaultPickupItem() {
        return this.getCleaverStack();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_FOIL, (Object)false);
        builder.define(DATA_ITEM_STACK, (Object)ItemStack.EMPTY);
    }

    public void playerTouch(Player player) {
    }

    protected void updateRotation() {
        this.setXRot(0.0f);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            ++this.soundTickCounter;
            if (this.soundTickCounter >= 4 + this.tickCount / 10 && !this.inGround) {
                this.level().playSound(null, (Entity)this, DDSounds.CLEAVER_FLYING.get(), SoundSource.PLAYERS, Math.max(1.0f - (float)this.tickCount / 60.0f, 0.0f), 1.0f - (float)this.tickCount / 100.0f);
                this.soundTickCounter = 0;
            }
        }
        if (this.inGroundTime > this.despawnTime) {
            this.discard();
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (!this.isInGround()) {
            this.setXRot(this.xRotO - 45.0f);
        }
    }

    public boolean isInGround() {
        return this.inGround && this.ricochetsLeft <= 0;
    }

    public void setBaseDamage(double addedDamage) {
        this.damage = addedDamage * 1.5;
    }

    public double getBaseDamage() {
        return this.damage;
    }

    public int getSerratedLevel() {
        return this.serratedLevel;
    }

    public void setSerratedLevel(int newSerratedLevel) {
        this.serratedLevel += newSerratedLevel;
    }

    public void setFullyCharged(boolean newBoolean) {
        this.fullyCharged = newBoolean;
    }

    public boolean getFullyCharged() {
        return this.fullyCharged;
    }

    public void setLongCooldown(boolean newMissCooldown) {
        this.longCooldown = newMissCooldown;
    }

    public boolean getMissCooldown() {
        return this.longCooldown;
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        Entity vec31;
        this.blockSide = hitResult.getDirection();
        this.embeddedRotOffset = this.random.nextFloat() * 45.0f;
        if (this.ricochetsLeft <= 0) {
            Vec3 vec3 = hitResult.getLocation().subtract(this.getX(), this.getY(), this.getZ());
            this.setDeltaMovement(vec3);
            this.hasImpulse = true;
            vec31 = vec3.normalize().scale(0.05);
            this.setPos(this.getX() - vec31.x, this.getY() - vec31.y, this.getZ() - vec31.z);
            if (this.ricochetsLeft == 0) {
                this.inGround = true;
                this.shakeTime = 24;
                this.playSound(DDSounds.CLEAVER_HIT_BLOCK.get(), 2.0f, this.level().random.nextFloat() * 0.1f + 0.9f);
            }
        }
        if ((vec31 = this.getOwner()) instanceof Player) {
            Player player = (Player)vec31;
            if (this.ricochetsLeft > 0) {
                Vec3 reflected = new Vec3(this.getDeltaMovement().toVector3f().reflect((Vector3fc)hitResult.getDirection().step())).scale((double)0.8f);
                this.setDeltaMovement(reflected);
                this.setPos(this.getX() + reflected.x, this.getY() + reflected.y, this.getZ() + reflected.z);
                this.hasImpulse = true;
                ((ServerLevel)this.level()).getChunkSource().broadcast((Entity)this, (Packet)new ClientboundSetEntityMotionPacket(this.getId(), this.getDeltaMovement()));
                --this.ricochetsLeft;
                this.damage *= 1.25;
                this.playSound(DDSounds.CLEAVER_RICOCHET.get(), 1.0f, this.ricochetsPitch);
                this.ricochetsPitch += 0.25f;
            }
            if (!(player.getAbilities().instabuild || this.canBypassCooldowns || this.hasSetCooldown)) {
                if (this.longCooldown) {
                    for (Holder item : BuiltInRegistries.ITEM.getTagOrEmpty(DDTags.ItemT.CLEAVERS)) {
                        player.getCooldowns().addCooldown((Item)item.value(), 50);
                    }
                }
                if (!this.longCooldown) {
                    for (Holder item : BuiltInRegistries.ITEM.getTagOrEmpty(DDTags.ItemT.CLEAVERS)) {
                        player.getCooldowns().addCooldown((Item)item.value(), 50);
                    }
                }
                this.hasSetCooldown = true;
            }
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        Entity entity = hitResult.getEntity();
        Entity owner = this.getOwner();
        if (!(entity instanceof ItemEntity) && entity.hurt(new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DDDamageTypes.CLEAVER), (Entity)this, (Entity)(owner == null ? this : owner)), (float)this.damage)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (owner instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)owner;
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)livingOwner, (DamageSource)new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DDDamageTypes.CLEAVER)), (ItemStack)this.getWeaponItem());
                    }
                    if (this.isOnFire()) {
                        entity.setRemainingFireTicks(this.getRemainingFireTicks());
                    }
                    if (this.getSerratedLevel() > 0 && !entity.isInvulnerable()) {
                        int duration = 40 + this.getSerratedLevel() * 20;
                        if (this.getFullyCharged()) {
                            duration += 30;
                        }
                        if (living.hasEffect(DDEffects.SERRATED)) {
                            duration /= 2;
                            duration += living.getEffect(DDEffects.SERRATED).getDuration();
                        }
                        living.addEffect(new MobEffectInstance(DDEffects.SERRATED, duration, 0));
                        living.playSound(DDSounds.CLEAVER_SERRATED_STRIKE.get(), 2.0f, 1.0f);
                    }
                    this.damage *= 0.8;
                }
                this.doPostHurtEffects(living);
            }
            if (this.getSerratedLevel() <= 0 && !entity.isInvulnerable()) {
                entity.playSound(DDSounds.CLEAVER_HIT_ENTITY.get(), 2.5f, this.level().random.nextFloat() * 0.1f + 0.9f);
            }
        }
        if (owner instanceof Player) {
            Player player = (Player)owner;
            if (entity != owner && !(entity instanceof CleaverEntity)) {
                this.canBypassCooldowns = true;
                player.getCooldowns().removeCooldown(this.getCleaverStack().getItem());
            }
        }
    }

    protected boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) || entity.isAlive() && entity instanceof ItemEntity;
    }

    protected float getWaterInertia() {
        return 0.75f;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("cleaver", this.cleaverItem.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        tag.put("item", this.getCleaverStack().save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        if (this.blockSide != null) {
            tag.putInt("BlockSide", this.blockSide.ordinal());
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("cleaver", 10)) {
            this.cleaverItem = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)tag.getCompound("cleaver")).orElse(DDItems.FLINT_CLEAVER.get().getDefaultInstance());
        }
        if (tag.contains("item", 10)) {
            this.setItem(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)tag.getCompound("item")).orElse(DDItems.FLINT_CLEAVER.get().getDefaultInstance()));
        }
        if (tag.contains("BlockSide")) {
            this.blockSide = Direction.values()[tag.getInt("BlockSide")];
        }
    }

    public boolean shouldRender(double pX, double pY, double pZ) {
        return true;
    }

    public void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED) {
            super.tickDespawn();
        }
    }
}

