/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.monster_yam;

import net.azurune.runiclib.RunicLib;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamAnimations;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamEntity;
import org.joml.Vector3f;

public class MonsterYamEntityModel<T extends MonsterYamEntity>
extends HierarchicalModel<T> {
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();
    public static final ModelLayerLocation LAYER_LOC = new ModelLayerLocation(RunicLib.customid((String)"dungeonsdelight", (String)"monster_yam"), "main");
    private final ModelPart root;
    private final ModelPart center;
    private final ModelPart flower;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart lower;

    public MonsterYamEntityModel(ModelPart root) {
        this.root = root.getChild("root");
        this.center = this.root.getChild("center");
        this.flower = this.center.getChild("flower");
        this.leftarm = this.center.getChild("leftarm");
        this.leftarm.getChild("forearm");
        this.rightarm = this.center.getChild("rightarm");
        this.rightarm.getChild("forearm2");
        this.rightarm.getChild("forearm3");
        this.center.getChild("flower");
        this.lower = this.root.getChild("lower");
        this.lower.getChild("rightleg");
        this.lower.getChild("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition center = root.addOrReplaceChild("center", CubeListBuilder.create().texOffs(46, 40).addBox(-5.0f, -8.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(46, 15).addBox(-5.0f, -8.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.5f)).texOffs(0, 25).addBox(-7.0f, -18.0f, -7.0f, 14.0f, 11.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-7.0f, -18.0f, -7.0f, 14.0f, 11.0f, 14.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-17.0f, (float)0.0f));
        PartDefinition leftarm = center.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(66, 0).addBox(1.0f, 18.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(56, 0).addBox(1.0f, 18.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offset((float)7.0f, (float)-14.0f, (float)0.5f));
        leftarm.addOrReplaceChild("forearm", CubeListBuilder.create().texOffs(50, 58).addBox(-1.0f, -2.0f, -3.0f, 4.0f, 20.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(32, 53).addBox(-1.0f, -2.0f, -3.0f, 4.0f, 20.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offset((float)1.0f, (float)0.0f, (float)0.5f));
        PartDefinition rightarm = center.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(66, 0).mirror().addBox(-3.0f, 18.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(56, 0).mirror().addBox(-3.0f, 18.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(0.2f)).mirror(false), PartPose.offset((float)-7.0f, (float)-14.0f, (float)0.5f));
        rightarm.addOrReplaceChild("forearm2", CubeListBuilder.create().texOffs(50, 58).mirror().addBox(-3.0f, -2.0f, -3.0f, 4.0f, 20.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.0f, (float)0.0f, (float)0.5f));
        rightarm.addOrReplaceChild("forearm3", CubeListBuilder.create().texOffs(32, 53).mirror().addBox(-3.0f, -2.0f, -3.0f, 4.0f, 20.0f, 5.0f, new CubeDeformation(0.2f)).mirror(false), PartPose.offset((float)-1.0f, (float)0.0f, (float)0.5f));
        PartDefinition flower = center.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-17.0f, (float)-0.2929f));
        flower.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 50).addBox(-7.2929f, -25.0f, 0.2929f, 16.0f, 25.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)-0.7071f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        flower.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 50).mirror().addBox(-8.7071f, -25.0f, 0.2929f, 16.0f, 25.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)-0.7071f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition lower = root.addOrReplaceChild("lower", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-17.0f, (float)-0.5f));
        lower.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 75).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(68, 58).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.2f)).mirror(false), PartPose.offset((float)-2.5f, (float)0.0f, (float)0.0f));
        lower.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 75).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(68, 58).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offset((float)2.5f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(MonsterYamEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(MonsterYamAnimations.walking, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        this.flower.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.flower.xRot = headPitch * ((float)Math.PI / 180);
    }

    protected void animateWalk(AnimationDefinition definition, float limbSwing, float limbSwingAmount, float maxAnimationSpeed, float scaleFactor) {
        long i = (long)(limbSwing * 50.0f * maxAnimationSpeed);
        float f = Math.min(limbSwingAmount * scaleFactor, 1.0f);
        KeyframeAnimations.animate((HierarchicalModel)this, (AnimationDefinition)definition, (long)i, (float)f, (Vector3f)ANIMATION_VECTOR_CACHE);
    }

    public ModelPart root() {
        return this.root;
    }
}

