/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.zombified_dryad;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDCriteriaTriggers;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

public class ZombifiedDryadEntity
extends Zombie {
    private static final int SLICE_FLING_ID = 39;

    public ZombifiedDryadEntity(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ARMOR, 6.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                int duration = 4;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    duration = 6;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    duration = 8;
                }
                living.addEffect(new MobEffectInstance(DDEffects.PUTRID_SCENT, duration * 20, 0), (Entity)this);
            }
            return true;
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (!this.hasEffect(DDEffects.RAVENOUS_RUSH) && this.getItemBySlot(EquipmentSlot.HEAD).is(DDItems.LIVING_JACK_O_LANTERN.get())) {
            this.addEffect(new MobEffectInstance(DDEffects.ROTGUT, 20, 0));
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Player player;
        Entity entity = source.getEntity();
        if ((entity instanceof Player && (player = (Player)entity).getMainHandItem().is(ModTags.KNIVES) || source.is(DDDamageTypes.CLEAVER)) && this.getItemBySlot(EquipmentSlot.HEAD).is(DDItems.LIVING_JACK_O_LANTERN.get()) && !this.level().isClientSide) {
            this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
            this.playSound((SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get());
            this.flingDatSlice(DDItems.ROTGOURD_SLICE.get().getDefaultInstance(), -0.5f, 1.0f, -0.5f, true, false);
            this.flingDatSlice(DDItems.ROTGOURD_SLICE.get().getDefaultInstance(), -0.5f, 1.0f, -0.5f, true, true);
            this.flingDatSlice(DDItems.ROTGOURD_SLICE.get().getDefaultInstance(), 0.5f, 1.0f, 0.5f, false, false);
            this.flingDatSlice(DDItems.ROTGOURD_SLICE.get().getDefaultInstance(), 0.5f, 1.0f, 0.5f, false, true);
            int expOutput = 3 + this.level().random.nextInt(5) + this.level().random.nextInt(5);
            ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (int)expOutput);
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)DDParticles.SPIRIT.get(), this.getX(), this.getY() + 1.0, this.getZ(), 12, 0.25, 0.25, 0.25, 0.1);
            this.level().broadcastEntityEvent((Entity)this, (byte)39);
            Entity entity2 = source.getEntity();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)entity2;
                DDCriteriaTriggers.FREE_DRYAD.get().trigger(player2.connection.getPlayer());
            }
        }
        return super.hurt(source, amount);
    }

    public void handleEntityEvent(byte id) {
        ItemStack entityStack = new ItemStack((ItemLike)DDItems.ROTGOURD_SLICE.get());
        if (id == 39) {
            for (int i = 0; i < 12; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, entityStack), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() * 2.0 - 1.0) * 0.1, ((double)this.random.nextFloat() * 2.0 - 1.0) * 0.1 + 0.1, ((double)this.random.nextFloat() * 2.0 - 1.0) * 0.1);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Nullable
    public ItemEntity flingDatSlice(ItemStack stack, float offsetX, float offsetY, float offsetZ, boolean reverseX, boolean reverseZ) {
        if (stack.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.level(), this.getX() + (double)offsetX, this.getY() + (double)offsetY, this.getZ() + (double)offsetZ, stack);
        itementity.setDefaultPickUpDelay();
        double velocity = 0.15;
        itementity.setDeltaMovement(reverseX ? -velocity : velocity, 0.0, reverseZ ? -velocity : velocity);
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.level().addFreshEntity((Entity)itementity);
        }
        return itementity;
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, SpawnGroupData data) {
        data = super.finalizeSpawn(accessor, difficultyInstance, spawnType, data);
        if (this.getItemBySlot(EquipmentSlot.OFFHAND).isEmpty() && accessor.getRandom().nextFloat() < 0.03f) {
            this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)DDItems.ROTBULB.get()));
            this.setGuaranteedDrop(EquipmentSlot.OFFHAND);
        }
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty() && accessor.getRandom().nextFloat() < 0.25f) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)DDItems.LIVING_JACK_O_LANTERN.get()));
        }
        return data;
    }

    protected boolean canReplaceCurrentItem(ItemStack stack, ItemStack stack1) {
        if (stack1.is(DDItems.ROTBULB.get())) {
            return false;
        }
        return super.canReplaceCurrentItem(stack, stack1);
    }

    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }

    protected SoundEvent getAmbientSound() {
        return DDSounds.ZOMBIFIED_DRYAD_AMBIENT.get();
    }

    protected SoundEvent getStepSound() {
        return DDSounds.ZOMBIFIED_DRYAD_STEP.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return DDSounds.ZOMBIFIED_DRYAD_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return DDSounds.ZOMBIFIED_DRYAD_DEATH.get();
    }
}

