/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food;

import java.util.List;
import net.azurune.runiclib.core.register.RLMobEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.util.DDUtil;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class BloodyMaryItem
extends DrinkableItem {
    public BloodyMaryItem(Item.Properties properties, boolean hasFoodEffectTooltip) {
        super(properties, hasFoodEffectTooltip, false);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        super.finishUsingItem(stack, level, living);
        if (!level.isClientSide && living instanceof Player) {
            Player player = (Player)living;
            for (int i = 0; i < DDUtil.NORMAL_EFFECTS.size(); ++i) {
                if (!player.hasEffect(DDUtil.NORMAL_EFFECTS.get(i))) continue;
                DDUtil.applyMonsterEffectSwap((LivingEntity)player, DDUtil.NORMAL_EFFECTS.get(i), DDUtil.MONSTER_EFFECTS.get(i));
                break;
            }
            if (!player.hasEffect(DDEffects.ROTGUT)) {
                player.hurt(ModDamageTypes.getSimpleDamageSource((Level)level, DDDamageTypes.BLOODY_MARY), 6.0f);
            } else {
                player.removeEffect(DDEffects.ROTGUT);
            }
            player.addEffect(new MobEffectInstance(RLMobEffects.BLEEDING, 140, 0));
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.bloody_mary", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            super.appendHoverText(stack, ctx, tooltip, isAdvanced);
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_DRINK;
    }
}

