/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food_type;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class BiteableItem
extends ConsumableItem {
    private int stackSize;

    public BiteableItem(Item.Properties properties, int stackSize, boolean hasPotionEffectTooltip) {
        super(properties, hasPotionEffectTooltip, false);
        this.stackSize = stackSize;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.biteable", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            super.appendHoverText(stack, ctx, tooltip, isAdvanced);
        }
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack enchantBook) {
        return false;
    }

    public int getBarColor(ItemStack stack) {
        return TextColor.fromRgb((int)13137346).getValue();
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.stackSize;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.isClientSide) {
            this.affectConsumer(stack, level, consumer);
        }
        ItemStack containerStack = stack.getCraftingRemainingItem();
        Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
        if (stack.getFoodProperties(consumer) != null) {
            FoodProperties foodProperties = stack.getFoodProperties(consumer);
            if (player != null) {
                player.getFoodData().eat(foodProperties.nutrition(), foodProperties.saturation());
            }
            if (!level.isClientSide && !player.level().isClientSide()) {
                for (FoodProperties.PossibleEffect possibleEffect : foodProperties.effects()) {
                    if (!(player.getRandom().nextFloat() < possibleEffect.probability())) continue;
                    player.addEffect(possibleEffect.effect());
                }
            }
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                if (stack.getDamageValue() >= stack.getMaxDamage()) {
                    if (!containerStack.isEmpty() && !player.getInventory().add(containerStack)) {
                        player.drop(containerStack, false);
                    }
                    stack.setDamageValue(0);
                    player.playSound(SoundEvents.PLAYER_BURP);
                }
            }
        }
        return stack;
    }
}

