/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food_type;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.item.food_type.EXPFoodItem;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class EXPPoisonPotatoesItem
extends EXPFoodItem {
    private final int experience;

    public EXPPoisonPotatoesItem(Item.Properties properties, int experience, boolean hasFoodEffectTooltip) {
        super(properties, experience, hasFoodEffectTooltip);
        this.experience = experience;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        Player player;
        super.finishUsingItem(stack, level, living);
        if (!level.isClientSide && living instanceof Player && (player = (Player)living).hasEffect(MobEffects.POISON)) {
            player.removeEffect(MobEffects.POISON);
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, this.experience * 20, 0));
            player.playSound(SoundEvents.ZOMBIE_VILLAGER_CURE, 0.5f, 1.0f);
        }
        return stack;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            String translationKey = this.experience < 6 ? "tooltip.small_xp_poison_potato" : (this.experience < 15 ? "tooltip.average_xp_poison_potato" : "tooltip.large_xp_poison_potato");
            tooltip.add((Component)TextUtils.getTranslation((String)translationKey, (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            super.appendHoverText(stack, ctx, tooltip, isAdvanced);
        }
    }
}

