/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food_type;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.core.registry.DDCriteriaTriggers;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SlimeFoodItem
extends Item {
    private final boolean hasFoodEffectTooltip;
    private final float chance;

    public SlimeFoodItem(Item.Properties properties, float chance, boolean hasFoodEffectTooltip) {
        super(properties);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.chance = chance;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        if (!level.isClientSide) {
            this.affectConsumer(stack, level, consumer);
        }
        boolean successfulChance = level.random.nextFloat() < this.chance;
        ItemStack containerStack = stack.getCraftingRemainingItem();
        if (stack.getFoodProperties(consumer) != null) {
            super.finishUsingItem(stack, level, consumer);
            if (consumer instanceof Player && successfulChance) {
                player = (Player)consumer;
                player.getInventory().add(new ItemStack((ItemLike)this, 1));
                player.playSound(SoundEvents.SLIME_JUMP, 0.7f, 0.7f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    DDCriteriaTriggers.SLIME_FOOD.get().trigger(serverPlayer);
                }
            }
        } else {
            Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
            }
            if (player != null) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
        }
        if (stack.isEmpty() && !successfulChance) {
            return containerStack;
        }
        if (consumer instanceof Player) {
            player = (Player)consumer;
            if (!(successfulChance || ((Player)consumer).getAbilities().instabuild || player.getInventory().add(containerStack))) {
                player.drop(containerStack, false);
            }
        }
        return stack;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            int percent = Math.round(this.chance * 100.0f);
            tooltip.add((Component)Component.literal((String)(percent + "% ")).append((Component)Component.translatable((String)"farmersdelight.tooltip.chance_to_not_consume")).withStyle(ChatFormatting.BLUE));
        }
        if (this.hasFoodEffectTooltip) {
            TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)ctx.tickRate());
        }
    }
}

