/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.util.misc;

import net.azurune.runiclib.RunicLib;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.yirmiri.dungeonsdelight.common.util.misc.RottenHeartManager;

public record S2CRottenHeartsPacket(int hearts) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2CRottenHeartsPacket> TYPE = new CustomPacketPayload.Type(RunicLib.customid((String)"dungeonsdelight", (String)"rotten_hearts"));
    public static final StreamCodec<FriendlyByteBuf, S2CRottenHeartsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, S2CRottenHeartsPacket::hearts, S2CRottenHeartsPacket::new);

    public S2CRottenHeartsPacket(FriendlyByteBuf buf) {
        this(buf.readInt());
    }

    public static void handle(S2CRottenHeartsPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                RottenHeartManager.get((LivingEntity)player).setRottenHearts(msg.hearts());
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

