/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.worldgen.feature.wormroot;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.MultifaceGrowthFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration;
import net.yirmiri.dungeonsdelight.common.block.WormrootsStalkBlock;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;

public class WormrootFeature
extends Feature<MultifaceGrowthConfiguration> {
    public WormrootFeature(Codec<MultifaceGrowthConfiguration> ctx) {
        super(ctx);
    }

    private boolean canReplace(WorldGenLevel level, BlockPos pos) {
        return level.getBlockState(pos).isAir() || level.getBlockState(pos).canBeReplaced();
    }

    private void placeBlock(WorldGenLevel level, BlockPos pos, BlockState state) {
        if (this.canReplace(level, pos)) {
            if (state.is(DDBlocks.WORMROOT_STALK.get())) {
                this.setBlock((LevelWriter)level, pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)WormrootsStalkBlock.NORTH, (Comparable)Boolean.valueOf(level.getBlockState(pos.north()).is(DDBlocks.WORMROOT_STALK.get())))).setValue((Property)WormrootsStalkBlock.EAST, (Comparable)Boolean.valueOf(level.getBlockState(pos.east()).is(DDBlocks.WORMROOT_STALK.get())))).setValue((Property)WormrootsStalkBlock.SOUTH, (Comparable)Boolean.valueOf(level.getBlockState(pos.south()).is(DDBlocks.WORMROOT_STALK.get())))).setValue((Property)WormrootsStalkBlock.WEST, (Comparable)Boolean.valueOf(level.getBlockState(pos.west()).is(DDBlocks.WORMROOT_STALK.get())))).setValue((Property)WormrootsStalkBlock.UP, (Comparable)Boolean.valueOf(level.getBlockState(pos.above()).is(DDBlocks.WORMROOT_STALK.get())))).setValue((Property)WormrootsStalkBlock.DOWN, (Comparable)Boolean.valueOf(level.getBlockState(pos.below()).is(DDBlocks.WORMROOT_STALK.get()))));
                for (Direction direction : Direction.values()) {
                    if (!level.getBlockState(pos.relative(direction)).is(DDBlocks.WORMROOT_STALK.get())) continue;
                    this.setBlock((LevelWriter)level, pos.relative(direction), (BlockState)level.getBlockState(pos.relative(direction)).setValue((Property)WormrootsStalkBlock.DIRECTION_TO_PROPERTY.get(direction.getOpposite()), (Comparable)Boolean.valueOf(true)));
                }
            } else {
                this.setBlock((LevelWriter)level, pos, state);
            }
        }
    }

    private void replaceStonePlace(WorldGenLevel level, BlockPos pos, BlockState state) {
        if (level.getBlockState(pos).is(BlockTags.BASE_STONE_OVERWORLD)) {
            this.setBlock((LevelWriter)level, pos, state);
        }
    }

    private boolean placeMouthBranch(WorldGenLevel level, BlockPos pos, Direction direction, RandomSource random) {
        if (random.nextBoolean()) {
            if (this.canReplace(level, pos.relative(direction)) && this.canReplace(level, pos.relative(direction).below())) {
                this.placeBlock(level, pos.relative(direction), DDBlocks.WORMROOT_STALK.get().defaultBlockState());
                this.placeBlock(level, pos.relative(direction).below(), DDBlocks.WORMOUTH.get().defaultBlockState());
                return true;
            }
        } else if (this.canReplace(level, pos.relative(direction)) && this.canReplace(level, pos.relative(direction, 2)) && this.canReplace(level, pos.relative(direction, 2).below())) {
            this.placeBlock(level, pos.relative(direction), (BlockState)DDBlocks.WORMROOT_STALK.get().defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)direction.getAxis()));
            this.placeBlock(level, pos.relative(direction, 2), DDBlocks.WORMROOT_STALK.get().defaultBlockState());
            this.placeBlock(level, pos.relative(direction, 2).below(), DDBlocks.WORMOUTH.get().defaultBlockState());
            return true;
        }
        return false;
    }

    private void placeEndMouth(WorldGenLevel level, BlockPos pos, RandomSource random) {
        this.placeBlock(level, pos, DDBlocks.WORMROOT_STALK.get().defaultBlockState());
        this.placeBlock(level, pos.above(), DDBlocks.WORMROOT_STALK.get().defaultBlockState());
        this.placeMouthBranch(level, pos.above(), Direction.Plane.HORIZONTAL.getRandomDirection(random), random);
    }

    public boolean place(FeaturePlaceContext<MultifaceGrowthConfiguration> context) {
        int j;
        int i;
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin().above(2);
        Direction mainBranchDir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int firstHeight = random.nextInt(3, 4);
        int secondHeight = random.nextInt(2, 3);
        float mouthBranchChance = 0.0f;
        BlockState upDownState = DDBlocks.WORMROOT_STALK.get().defaultBlockState();
        this.replaceStonePlace(level, context.origin().above().below(), DDBlocks.WORMROOTS_BLOCK.get().defaultBlockState());
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                if (!random.nextBoolean()) continue;
                this.replaceStonePlace(level, context.origin().above().offset(i, -1, j), DDBlocks.WORMROOTS_BLOCK.get().defaultBlockState());
            }
        }
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                if (!random.nextBoolean()) continue;
                this.replaceStonePlace(level, context.origin().above().offset(i, -1, j), Blocks.COARSE_DIRT.defaultBlockState());
            }
        }
        level.setBlock(context.origin().above(), upDownState, 2);
        for (i = 0; i < firstHeight; ++i) {
            this.placeBlock(level, pos.above(i), upDownState);
            if (random.nextFloat() < mouthBranchChance && i > 0) {
                ArrayList dirs = new ArrayList(Direction.Plane.HORIZONTAL.stream().toList());
                dirs.remove(mainBranchDir);
                dirs.remove(mainBranchDir.getOpposite());
                Direction direction = (Direction)dirs.get(random.nextInt(0, dirs.size()));
                if (!this.placeMouthBranch(level, pos.above(i), direction, random)) continue;
                mouthBranchChance = 0.0f;
                continue;
            }
            mouthBranchChance += 0.3f;
        }
        pos = pos.above(firstHeight - 1);
        if (random.nextBoolean()) {
            int i2;
            firstOffset = random.nextInt(2, 3);
            for (i2 = 1; i2 < firstOffset; ++i2) {
                this.placeBlock(level, pos.relative(mainBranchDir, i2), (BlockState)upDownState.setValue((Property)BlockStateProperties.AXIS, (Comparable)mainBranchDir.getAxis()));
            }
            pos = pos.relative(mainBranchDir, firstOffset);
            for (i2 = 0; i2 < secondHeight; ++i2) {
                this.placeBlock(level, pos.above(i2), upDownState);
                if (random.nextFloat() < mouthBranchChance) {
                    if (!this.placeMouthBranch(level, pos.above(i2), Direction.Plane.HORIZONTAL.getRandomDirection(random), random)) continue;
                    mouthBranchChance = 0.0f;
                    continue;
                }
                mouthBranchChance += 0.4f;
            }
            this.placeEndMouth(level, pos.above(secondHeight), random);
        } else {
            firstOffset = random.nextInt(2, 3);
            for (int i3 = 1; i3 < firstOffset; ++i3) {
                this.placeBlock(level, pos.relative(mainBranchDir, i3), (BlockState)upDownState.setValue((Property)BlockStateProperties.AXIS, (Comparable)mainBranchDir.getAxis()));
            }
            BlockPos firstPos = pos.relative(mainBranchDir, firstOffset);
            for (int i4 = 0; i4 < secondHeight; ++i4) {
                this.placeBlock(level, firstPos.above(i4), upDownState);
                if (random.nextFloat() < mouthBranchChance) {
                    if (!this.placeMouthBranch(level, firstPos.above(i4), Direction.Plane.HORIZONTAL.getRandomDirection(random), random)) continue;
                    mouthBranchChance = 0.0f;
                    continue;
                }
                mouthBranchChance += 0.4f;
            }
            this.placeEndMouth(level, firstPos.above(secondHeight), random);
            boolean below = random.nextBoolean();
            int secondOffset = random.nextInt(2, 3);
            for (int i5 = 1; i5 < secondOffset; ++i5) {
                this.placeBlock(level, pos.relative(mainBranchDir.getOpposite(), i5).below(below ? 2 : 1), (BlockState)upDownState.setValue((Property)BlockStateProperties.AXIS, (Comparable)mainBranchDir.getAxis()));
            }
            BlockPos secondPos = pos.relative(mainBranchDir.getOpposite(), secondOffset).below(below ? 2 : 1);
            for (int i6 = 0; i6 < secondHeight; ++i6) {
                this.placeBlock(level, secondPos.above(i6), upDownState);
                if (random.nextFloat() < mouthBranchChance) {
                    if (!this.placeMouthBranch(level, secondPos.above(i6), Direction.Plane.HORIZONTAL.getRandomDirection(random), random)) continue;
                    mouthBranchChance = 0.0f;
                    continue;
                }
                mouthBranchChance += 0.4f;
            }
            this.placeEndMouth(level, secondPos.above(secondHeight), random);
        }
        for (i = 0; i < 6; ++i) {
            FeaturePlaceContext context1 = new FeaturePlaceContext(context.topFeature(), context.level(), context.chunkGenerator(), context.random(), context.origin().offset(random.nextInt(-2, 2), 0, random.nextInt(-2, 2)), (FeatureConfiguration)((MultifaceGrowthConfiguration)context.config()));
            this.placeTendrils((FeaturePlaceContext<MultifaceGrowthConfiguration>)context1);
        }
        return true;
    }

    public boolean placeTendrils(FeaturePlaceContext<MultifaceGrowthConfiguration> p_225165_) {
        WorldGenLevel worldgenlevel = p_225165_.level();
        BlockPos blockpos = p_225165_.origin();
        RandomSource randomsource = p_225165_.random();
        MultifaceGrowthConfiguration multifacegrowthconfiguration = (MultifaceGrowthConfiguration)p_225165_.config();
        if (!WormrootFeature.isAirOrWater(worldgenlevel.getBlockState(blockpos))) {
            return false;
        }
        List list = multifacegrowthconfiguration.getShuffledDirections(randomsource);
        if (MultifaceGrowthFeature.placeGrowthIfPossible((WorldGenLevel)worldgenlevel, (BlockPos)blockpos, (BlockState)worldgenlevel.getBlockState(blockpos), (MultifaceGrowthConfiguration)multifacegrowthconfiguration, (RandomSource)randomsource, (List)list)) {
            return true;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockpos.mutable();
        block0: for (Direction direction : list) {
            blockpos$mutableblockpos.set((Vec3i)blockpos);
            List list1 = multifacegrowthconfiguration.getShuffledDirectionsExcept(randomsource, direction.getOpposite());
            for (int i = 0; i < multifacegrowthconfiguration.searchRange; ++i) {
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, direction);
                BlockState blockstate = worldgenlevel.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (!WormrootFeature.isAirOrWater(blockstate) && !blockstate.is((Block)multifacegrowthconfiguration.placeBlock)) continue block0;
                if (!MultifaceGrowthFeature.placeGrowthIfPossible((WorldGenLevel)worldgenlevel, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate, (MultifaceGrowthConfiguration)multifacegrowthconfiguration, (RandomSource)randomsource, (List)list1)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAirOrWater(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER);
    }
}

