/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.event;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.yirmiri.dungeonsdelight.common.block.food.MonsterCakeBlock;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

@EventBusSubscriber(modid="dungeonsdelight")
public class DDCommonEvents {
    @SubscribeEvent
    public static void onMonsterCakeInteraction(PlayerInteractEvent.RightClickBlock event) {
        ItemStack toolStack = event.getEntity().getItemInHand(event.getHand());
        if (toolStack.is(ModTags.KNIVES)) {
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            BlockState state = event.getLevel().getBlockState(pos);
            Block block = state.getBlock();
            if (state.is(DDBlocks.CANDLE_MONSTER_CAKE.get())) {
                level.setBlock(pos, (BlockState)DDBlocks.MONSTER_CAKE.get().defaultBlockState().setValue((Property)MonsterCakeBlock.BITES, (Comparable)Integer.valueOf(1)), 3);
                Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
                ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)DDItems.MONSTER_CAKE_SLICE.get()), (double)pos.getX(), (double)((double)pos.getY() + 0.2), (double)((double)pos.getZ() + 0.5), (double)-0.05, (double)0.0, (double)0.0);
                level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
            if (block == DDBlocks.MONSTER_CAKE.get()) {
                int bites = (Integer)state.getValue((Property)MonsterCakeBlock.BITES);
                if (bites < 6) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)MonsterCakeBlock.BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
                } else {
                    level.removeBlock(pos, false);
                }
                ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)DDItems.MONSTER_CAKE_SLICE.get()), (double)((double)pos.getX() + (double)bites * 0.1), (double)((double)pos.getY() + 0.2), (double)((double)pos.getZ() + 0.5), (double)-0.05, (double)0.0, (double)0.0);
                level.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

