/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.datagen;

import net.azurune.runiclib.RunicLib;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class DDBlockstateGen
extends BlockStateProvider {
    public DDBlockstateGen(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "dungeonsdelight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.cubeAllWithItem(DDBlocks.WORMWOOD_PLANKS.get());
        this.stairsWithItem((StairBlock)DDBlocks.WORMWOOD_STAIRS.get(), DDBlocks.WORMWOOD_PLANKS.get());
        this.slabWithItem((SlabBlock)DDBlocks.WORMWOOD_SLAB.get(), DDBlocks.WORMWOOD_PLANKS.get());
        this.doorBlock((DoorBlock)DDBlocks.WORMWOOD_DOOR.get(), "wormwood", RunicLib.customid((String)"dungeonsdelight", (String)"block/wormwood_door_bottom"), RunicLib.customid((String)"dungeonsdelight", (String)"block/wormwood_door_top"));
        this.fenceWithItem((FenceBlock)DDBlocks.WORMWOOD_FENCE.get(), DDBlocks.WORMWOOD_PLANKS.get());
        this.fenceGateWithItem((FenceGateBlock)DDBlocks.WORMWOOD_FENCE_GATE.get(), DDBlocks.WORMWOOD_PLANKS.get());
        this.pressurePlateWithItem((PressurePlateBlock)DDBlocks.WORMWOOD_PRESSURE_PLATE.get(), DDBlocks.WORMWOOD_PLANKS.get());
        this.buttonWithItem((ButtonBlock)DDBlocks.WORMWOOD_BUTTON.get(), DDBlocks.WORMWOOD_PLANKS.get());
        this.trapdoorWithItem((TrapDoorBlock)DDBlocks.WORMWOOD_TRAPDOOR.get(), DDBlocks.WORMWOOD_TRAPDOOR.get());
        this.cubeAllWithItem(DDBlocks.WORMWOOD_MOSAIC.get());
        this.stairsWithItem((StairBlock)DDBlocks.WORMWOOD_MOSAIC_STAIRS.get(), DDBlocks.WORMWOOD_MOSAIC.get());
        this.slabWithItem((SlabBlock)DDBlocks.WORMWOOD_MOSAIC_SLAB.get(), DDBlocks.WORMWOOD_MOSAIC.get());
        this.cabinetBlock((CabinetBlock)DDBlocks.WORMWOOD_CABINET.get(), "wormwood");
        this.cubeAllWithItem(DDBlocks.SCULK_MAYO_BLOCK.get());
        this.cubeAllWithItem(DDBlocks.WORMROOTS_BLOCK.get());
        this.specialCrateBlock(DDBlocks.ROTBULB_CRATE.get(), "rotbulb");
        this.topBottomSideBlock(DDBlocks.CHISELED_STAINED_SCRAP.get(), "chiseled_stained_scrap");
        this.cubeAllWithItem(DDBlocks.CUT_STAINED_SCRAP.get());
        this.stairsWithItem((StairBlock)DDBlocks.CUT_STAINED_SCRAP_STAIRS.get(), DDBlocks.CUT_STAINED_SCRAP.get());
        this.slabWithItem((SlabBlock)DDBlocks.CUT_STAINED_SCRAP_SLAB.get(), DDBlocks.CUT_STAINED_SCRAP.get());
        this.cubeAllWithItem(DDBlocks.STAINED_SCRAP_BLOCK.get());
        this.specialCrateBlock(DDBlocks.POISONOUS_POTATO_CRATE.get(), "poisonous_potato");
        this.specialCrateBlock(DDBlocks.ROTTEN_TOMATO_CRATE.get(), "rotten_tomato");
        this.topBlock(DDBlocks.STAINED_LANTERN.get(), "stained_lantern");
        this.logBlock((RotatedPillarBlock)DDBlocks.STAINED_SCRAP_PILLAR.get());
        this.trapdoorWithItem((TrapDoorBlock)DDBlocks.STAINED_SCRAP_TRAPDOOR.get(), DDBlocks.STAINED_SCRAP_TRAPDOOR.get());
        this.doorBlock((DoorBlock)DDBlocks.STAINED_SCRAP_DOOR.get(), "stained_scrap", RunicLib.customid((String)"dungeonsdelight", (String)"block/stained_scrap_door_bottom"), RunicLib.customid((String)"dungeonsdelight", (String)"block/stained_scrap_door_top"));
    }

    private ResourceLocation getKey(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    private String key(Block block) {
        return this.getKey(block).getPath();
    }

    private void cubeAllWithItem(Block block) {
        this.simpleBlockWithItem(block, this.cubeAll(block));
    }

    private void stairsWithItem(StairBlock block, Block blockTexture) {
        this.stairsBlock(block, this.blockTexture(blockTexture));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().stairs(this.key((Block)block), this.blockTexture(blockTexture), this.blockTexture(blockTexture), this.blockTexture(blockTexture)));
    }

    private void slabWithItem(SlabBlock block, Block blockTexture) {
        this.slabBlock(block, this.blockTexture(blockTexture), this.blockTexture(blockTexture));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().slab(this.key((Block)block), this.blockTexture(blockTexture), this.blockTexture(blockTexture), this.blockTexture(blockTexture)));
    }

    public void barsBlock(Block block, ResourceLocation pane, ResourceLocation edge) {
        this.paneBlockWithRenderType((IronBarsBlock)block, pane, edge, "cutout");
    }

    public void topBlock(Block block, String id) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.key(block), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + id)), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + id + "_top")), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + id + "_top"))));
    }

    private void fenceWithItem(FenceBlock block, Block blockTexture) {
        this.fenceBlock(block, this.blockTexture(blockTexture));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().fenceInventory(this.key((Block)block), this.blockTexture(blockTexture)));
    }

    private void fenceGateWithItem(FenceGateBlock block, Block blockTexture) {
        this.fenceGateBlock(block, this.blockTexture(blockTexture));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().fenceGate(this.key((Block)block), this.blockTexture(blockTexture)));
    }

    private void pressurePlateWithItem(PressurePlateBlock block, Block blockTexture) {
        this.pressurePlateBlock(block, this.blockTexture(blockTexture));
        this.simpleBlockItem((Block)block, (ModelFile)this.models().pressurePlate(this.key((Block)block), this.blockTexture(blockTexture)));
    }

    private void buttonWithItem(ButtonBlock block, Block blockTexture) {
        this.buttonBlock(block, this.blockTexture(blockTexture));
    }

    private void trapdoorWithItem(TrapDoorBlock block, Block blockTexture) {
        this.trapdoorBlock(block, this.blockTexture(blockTexture), true);
        this.simpleBlockItem((Block)block, (ModelFile)this.models().trapdoorOrientableBottom(this.key((Block)block), this.blockTexture(blockTexture)));
    }

    public void topBottomSideBlock(Block block, String id) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.key(block), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + id + "_side")), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + id + "_bottom")), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + id + "_top"))));
    }

    public void specialCrateBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.key(block), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + cropName + "_crate_side")), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + cropName + "_crate_bottom")), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + cropName + "_crate_top"))));
    }

    public void cabinetBlock(CabinetBlock block, String woodType) {
        this.horizontalBlock((Block)block, state -> {
            String suffix = (Boolean)state.getValue((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.key((Block)block) + suffix, RunicLib.customid((String)"dungeonsdelight", (String)("block/" + woodType + "_cabinet_side")), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + woodType + "_cabinet_front" + suffix)), RunicLib.customid((String)"dungeonsdelight", (String)("block/" + woodType + "_cabinet_top")));
        });
    }
}

