/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.integration.common;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.integration.common.INBiteableItem;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class INArcaneChiliItem
extends INBiteableItem {
    private final boolean hasFoodEffectTooltip;

    public INArcaneChiliItem(String modid, Item.Properties properties, boolean hasPotionEffectTooltip) {
        super(modid, properties, 1, hasPotionEffectTooltip);
        this.hasFoodEffectTooltip = hasPotionEffectTooltip;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity consumer) {
        if (!level.isClientSide) {
            MobEffectInstance effect = switch (level.getRandom().nextInt(4)) {
                case 0 -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 2400, 1);
                case 1 -> new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1200, 0);
                case 2 -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1200, 0);
                case 3 -> new MobEffectInstance(MobEffects.JUMP, 2400, 2);
                default -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 0);
            };
            consumer.addEffect(effect);
        }
        return super.finishUsingItem(stack, level, consumer);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.arcane_chili", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)ctx.tickRate());
            }
        }
    }
}

