/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.dungeonsdelight.common.block.MonsterCakeBlock;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;

public class CandleMonsterCakeBlock
extends AbstractCandleBlock {
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    protected static final VoxelShape CAKE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape CANDLE_SHAPE = Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)CAKE_SHAPE, (VoxelShape)CANDLE_SHAPE);
    private static final Map<Block, CandleMonsterCakeBlock> BY_CANDLE = Maps.newHashMap();
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));

    public CandleMonsterCakeBlock(Block block, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        BY_CANDLE.put(block, this);
    }

    protected Iterable<Vec3> m_142199_(BlockState p_152868_) {
        return PARTICLE_OFFSETS;
    }

    public VoxelShape m_5940_(BlockState p_152875_, BlockGetter p_152876_, BlockPos p_152877_, CollisionContext p_152878_) {
        return SHAPE;
    }

    public void m_214162_(BlockState p_220697_, Level p_220698_, BlockPos p_220699_, RandomSource p_220700_) {
        if (((Boolean)p_220697_.m_61143_((Property)LIT)).booleanValue()) {
            this.m_142199_(p_220697_).forEach(p_220695_ -> CandleMonsterCakeBlock.m_220687_(p_220698_, p_220695_.m_82520_((double)p_220699_.m_123341_(), (double)p_220699_.m_123342_(), (double)p_220699_.m_123343_()), p_220700_));
        }
    }

    private static void m_220687_(Level p_220688_, Vec3 p_220689_, RandomSource p_220690_) {
        float $$3 = p_220690_.m_188501_();
        if ($$3 < 0.3f) {
            p_220688_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, p_220689_.f_82479_, p_220689_.f_82480_, p_220689_.f_82481_, 0.0, 0.0, 0.0);
            if ($$3 < 0.17f) {
                p_220688_.m_7785_(p_220689_.f_82479_ + 0.5, p_220689_.f_82480_ + 0.5, p_220689_.f_82481_ + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + p_220690_.m_188501_(), p_220690_.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        p_220688_.m_7106_((ParticleOptions)DDParticles.LIVING_FLAME.get(), p_220689_.f_82479_, p_220689_.f_82480_, p_220689_.f_82481_, 0.0, 0.0, 0.0);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_150930_(Items.f_42409_) && !stack.m_150930_(Items.f_42613_)) {
            if (CandleMonsterCakeBlock.candleHit(hitResult) && player.m_21120_(hand).m_41619_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                CandleMonsterCakeBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            InteractionResult result = MonsterCakeBlock.m_51185_((LevelAccessor)level, pos, ((Block)DDBlocks.MONSTER_CAKE.get()).m_49966_(), player);
            if (result.m_19077_()) {
                CandleMonsterCakeBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    private static boolean candleHit(BlockHitResult result) {
        return result.m_82450_().f_82480_ - (double)result.m_82425_().m_123342_() > 0.5;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{LIT});
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)DDBlocks.MONSTER_CAKE.get());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor accessor, BlockPos pos, BlockPos pos1) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)accessor, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, state1, accessor, pos, pos1);
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.m_8055_(pos.m_7495_()).m_280296_();
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return MonsterCakeBlock.f_152743_;
    }

    public boolean m_7278_(BlockState p_152909_) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static BlockState byCandle(Block block) {
        return BY_CANDLE.get(block).m_49966_();
    }

    public static boolean canLight(BlockState state) {
        return state.m_204338_(BlockTags.f_144268_, base -> base.m_61138_((Property)LIT) && (Boolean)state.m_61143_((Property)LIT) == false);
    }
}

