/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.dungeonsdelight.common.item.StainedCleaverItem;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import org.joml.Vector3fc;

public class CleaverEntity
extends AbstractArrow {
    public static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(CleaverEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(CleaverEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public ItemStack cleaverItem;
    private double damage = 0.0;
    public boolean canBypassCooldowns = false;
    public int despawnTime = 200;
    public boolean spinning = true;
    public boolean hasSetCooldown = false;
    public float ricochetsPitch = 1.0f;
    public int ricochetsLeft = 0;
    public int serratedLevel = 0;
    public int retractionLevel = 0;
    public int persistenceLevel = 0;
    public int soundTickCounter = 0;

    public CleaverEntity(EntityType<? extends CleaverEntity> type, Level level) {
        super(type, level);
    }

    public CleaverEntity(EntityType<? extends CleaverEntity> type, Level level, Player living, ItemStack stack) {
        super(type, (LivingEntity)living, level);
        this.cleaverItem = this.getItem();
        this.cleaverItem = this.getItem().m_41777_();
        this.f_19804_.m_135381_(ID_FOIL, (Object)stack.m_41790_());
    }

    public CleaverEntity(EntityType<? extends CleaverEntity> type, Level level, Position pos, ItemStack stack) {
        super(type, level);
        this.cleaverItem = this.getItem();
        this.cleaverItem = this.getItem().m_41777_();
        this.f_19804_.m_135381_(ID_FOIL, (Object)stack.m_41790_());
    }

    public CleaverEntity(EntityType<? extends CleaverEntity> type, Level level, double x, double y, double z) {
        super(type, x, y, z, level);
    }

    public void setItem(ItemStack stack) {
        if (stack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)stack.m_255036_(1));
        }
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack getItem() {
        ItemStack stack = this.getItemRaw();
        return stack.m_41619_() ? new ItemStack((ItemLike)DDItems.FLINT_CLEAVER.get()) : stack;
    }

    public ItemStack m_7941_() {
        return this.getItem();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    protected void m_37283_() {
        this.m_146926_(0.0f);
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    public void m_6123_(Player player) {
        if (this.persistenceLevel > 0 && this.f_36703_ && this.m_150171_((Entity)player) || this.m_19749_() == null && player.m_36335_().m_41519_(this.getItem().m_41720_())) {
            player.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            player.m_36335_().m_41527_(this.getItem().m_41720_());
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ++this.soundTickCounter;
            if (this.soundTickCounter >= 4 && !this.f_36703_) {
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)DDSounds.CLEAVER_FLYING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                this.soundTickCounter = 0;
            }
        }
        if (this.f_36704_ > this.despawnTime) {
            this.m_146870_();
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (!this.isInGround()) {
            this.m_146926_(this.f_19860_ - 45.0f);
        }
    }

    public boolean isInGround() {
        return this.f_36703_ && this.ricochetsLeft <= 0;
    }

    public void m_36781_(double addedDamage) {
        this.damage = addedDamage * 1.66;
    }

    public double m_36789_() {
        return this.damage;
    }

    protected void m_8060_(BlockHitResult hitResult) {
        Entity vec31;
        if (this.ricochetsLeft <= 0) {
            Vec3 vec3 = hitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_20256_(vec3);
            this.f_19812_ = true;
            vec31 = vec3.m_82541_().m_82490_(0.05);
            this.m_6034_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
            if (this.ricochetsLeft == 0) {
                this.f_36703_ = true;
                this.f_36706_ = 24;
                this.m_5496_((SoundEvent)DDSounds.CLEAVER_HIT_BLOCK.get(), 2.0f, 1.0f);
            }
        }
        if ((vec31 = this.m_19749_()) instanceof Player) {
            Player player = (Player)vec31;
            if (!(player.m_150110_().f_35937_ || this.canBypassCooldowns || this.hasSetCooldown)) {
                player.m_36335_().m_41524_(this.getItem().m_41720_(), 50);
                if (this.ricochetsLeft == 0) {
                    this.hasSetCooldown = true;
                }
            }
            if (this.ricochetsLeft > 0) {
                Vec3 reflected = new Vec3(this.m_20184_().m_252839_().reflect((Vector3fc)hitResult.m_82434_().m_253071_())).m_82490_((double)0.8f);
                this.m_20256_(reflected);
                this.m_6034_(this.m_20185_() + reflected.f_82479_, this.m_20186_() + reflected.f_82480_, this.m_20189_() + reflected.f_82481_);
                this.f_19812_ = true;
                ((ServerLevel)this.m_9236_()).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityMotionPacket(this.m_19879_(), this.m_20184_()));
                --this.ricochetsLeft;
                this.damage *= 1.25;
                this.m_5496_((SoundEvent)DDSounds.CLEAVER_RICOCHET.get(), 1.0f, this.ricochetsPitch);
                this.ricochetsPitch += 0.25f;
            }
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Player player;
        Entity entity;
        Entity entity2 = hitResult.m_82443_();
        Entity owner = this.m_19749_();
        if (this.getItem().m_150930_((Item)DDItems.STAINED_CLEAVER.get()) && this.m_19749_() != null && (entity = this.m_19749_()) instanceof Player) {
            player = (Player)entity;
            entity = hitResult.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                Item item = player.m_21205_().m_41720_();
                if (item instanceof StainedCleaverItem) {
                    StainedCleaverItem stainedCleaverItem = (StainedCleaverItem)item;
                    stainedCleaverItem.stainedEffects(player.m_21205_(), target, (LivingEntity)player);
                }
            }
        }
        if (!(entity2 instanceof ItemEntity) && entity2.m_6469_(new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DDDamageTypes.CLEAVER), (Entity)this, (Entity)(owner == null ? this : owner)), (float)this.damage)) {
            if (entity2.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity2 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity2;
                if (owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)living, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)living);
                    if (this.m_6060_()) {
                        entity2.m_20254_(this.m_20094_());
                    }
                    if (this.getSerratedLevel() > 0 && !entity2.m_20147_()) {
                        int duration = 80 + this.getSerratedLevel();
                        if (living.m_21023_((MobEffect)DDEffects.SERRATED.get())) {
                            duration += living.m_21124_((MobEffect)DDEffects.SERRATED.get()).m_19557_();
                        }
                        living.m_7292_(new MobEffectInstance((MobEffect)DDEffects.SERRATED.get(), duration, 0));
                        living.m_5496_((SoundEvent)DDSounds.CLEAVER_SERRATED_STRIKE.get(), 2.0f, 1.0f);
                    }
                    if (this.getPersistenceLevel() > 0 && !living.m_21023_(MobEffects.f_19597_)) {
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40 + this.getPersistenceLevel() * 20, 0));
                    }
                    this.damage *= 0.85;
                }
                this.m_7761_(living);
                if (this.retractionLevel > 0 && this.m_19749_() != null) {
                    if (!(entity2 instanceof Ghast)) {
                        this.pullEntity(entity2, 1.5f);
                    } else {
                        this.pullEntity(entity2, 2.0f);
                    }
                }
            }
            if (this.getSerratedLevel() <= 0 && !entity2.m_20147_()) {
                entity2.m_5496_((SoundEvent)DDSounds.CLEAVER_HIT_ENTITY.get(), 2.0f, 1.0f);
            }
        }
        if (owner instanceof Player) {
            player = (Player)owner;
            if (entity2 != owner) {
                this.canBypassCooldowns = true;
                player.m_36335_().m_41527_(this.getItem().m_41720_());
            }
        }
        if (this.retractionLevel > 0 && this.m_19749_() != null && entity2 instanceof ItemEntity) {
            this.pullEntity(entity2, 2.0f);
        }
    }

    public void pullEntity(Entity entity, float maxDistance) {
        if (this.retractionLevel > 0 && this.m_19749_() != null) {
            Vec3 direction = this.m_19749_().m_20182_().m_82546_(entity.m_20182_());
            double distance = direction.m_82553_();
            if (entity instanceof LivingEntity && distance <= 4.5) {
                return;
            }
            if (distance > 0.01) {
                Vec3 velocity = direction.m_82541_().m_82490_(Math.min((double)maxDistance, distance * 0.25));
                entity.m_20256_(entity.m_20184_().m_82549_(velocity));
                entity.m_5496_((SoundEvent)DDSounds.CLEAVER_FLYING.get(), 0.75f, -1.0f);
            }
            entity.f_19864_ = true;
        }
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) || entity.m_6084_() && entity instanceof ItemEntity;
    }

    public boolean isInCeiling() {
        if (this.f_19794_) {
            return false;
        }
        float f = 0.2f;
        BlockPos pos = BlockPos.m_274446_((Position)this.m_146892_().m_82520_(0.0, 1.0E-6, 0.0));
        BlockState blockstate = this.m_9236_().m_8055_(pos);
        return !blockstate.m_60795_() && blockstate.m_60828_((BlockGetter)this.m_9236_(), pos) && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_165882_((Vec3)this.m_146892_(), (double)0.1, (double)0.1, (double)0.1)), (BooleanOp)BooleanOp.f_82689_);
    }

    public int getPersistenceLevel() {
        return this.persistenceLevel;
    }

    public void setPersistenceLevel(int additionalPersistenceLevel) {
        this.persistenceLevel += additionalPersistenceLevel;
    }

    public int getRetractionLevel() {
        return this.retractionLevel;
    }

    public void setRetractionLevel(int additionalRetractionLevel) {
        this.retractionLevel += additionalRetractionLevel;
    }

    public int getSerratedLevel() {
        return this.serratedLevel;
    }

    public void setSerratedLevel(int additionalSerratedLevel) {
        this.serratedLevel += additionalSerratedLevel;
    }

    protected float m_6882_() {
        return 0.75f;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Cleaver", 10)) {
            this.cleaverItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Cleaver"));
        }
        this.setItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item")));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Cleaver", (Tag)this.cleaverItem.m_41739_(new CompoundTag()));
        if (!this.getItemRaw().m_41619_()) {
            tag.m_128365_("Item", (Tag)this.getItemRaw().m_41739_(new CompoundTag()));
        }
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }
}

