/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.entity.misc.CleaverEntity;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDEnchantments;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import vectorwing.farmersdelight.common.item.KnifeItem;

public class CleaverItem
extends KnifeItem {
    public final float range;

    public CleaverItem(float range, Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
        this.range = range;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.m_7579_(stack, target, attacker);
        int serratedStrikeLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DDEnchantments.SERRATED_STRIKE.get()), (ItemStack)stack);
        if (serratedStrikeLevel > 0) {
            int duration = 40 + serratedStrikeLevel;
            if (target.m_21023_((MobEffect)DDEffects.SERRATED.get())) {
                duration += target.m_21124_((MobEffect)DDEffects.SERRATED.get()).m_19557_();
            }
            target.m_7292_(new MobEffectInstance((MobEffect)DDEffects.SERRATED.get(), duration, 0));
            target.m_5496_((SoundEvent)DDSounds.CLEAVER_SERRATED_STRIKE.get(), 2.0f, 1.0f);
        }
        return true;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int timeLeft) {
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        if (this.m_8105_(stack) - timeLeft < 6 || player.m_36335_().m_41519_((Item)this)) {
            return;
        }
        if (!level.f_46443_) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(living.m_7655_()));
            CleaverEntity cleaver = new CleaverEntity((EntityType<? extends CleaverEntity>)((EntityType)DDEntities.CLEAVER.get()), level, player, stack.m_41777_());
            cleaver.setItem(stack.m_41777_());
            this.applyEnchantments(stack, cleaver);
            cleaver.m_36781_(cleaver.m_36789_() + (double)this.m_41008_());
            cleaver.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.range, 1.0f);
            if (player.m_150110_().f_35937_) {
                cleaver.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            }
            level.m_7967_((Entity)cleaver);
            level.m_6269_(null, (Entity)cleaver, (SoundEvent)DDSounds.CLEAVER_THROW.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    void applyEnchantments(ItemStack stack, CleaverEntity cleaver) {
        int persistence;
        int serrated;
        int ricochet;
        int fireAspect;
        int sharpness = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)stack);
        if (sharpness > 0) {
            cleaver.m_36781_(cleaver.m_36789_() + (double)sharpness * 0.5 + 0.5);
        }
        if ((fireAspect = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack)) > 0) {
            cleaver.m_20254_(100 * fireAspect);
        }
        if ((ricochet = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DDEnchantments.RICOCHET.get()), (ItemStack)stack)) > 0) {
            cleaver.ricochetsLeft += ricochet;
        }
        if ((serrated = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DDEnchantments.SERRATED_STRIKE.get()), (ItemStack)stack)) > 0) {
            cleaver.setSerratedLevel(serrated);
        }
        if ((persistence = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DDEnchantments.PERSISTENCE.get()), (ItemStack)stack)) > 0) {
            cleaver.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            cleaver.setPersistenceLevel(persistence);
            cleaver.despawnTime = 200 + persistence * 40;
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41773_() >= stack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        HashSet ALLOWED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_, Enchantments.f_44982_});
        if (ALLOWED_ENCHANTMENTS.contains(enchantment)) {
            return true;
        }
        HashSet DENIED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.f_44987_, Enchantments.f_44981_, Enchantments.f_44980_});
        return !DENIED_ENCHANTMENTS.contains(enchantment) && enchantment.f_44672_.m_7454_(stack.m_41720_());
    }
}

