/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.event.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.yirmiri.dungeonsdelight.DDConfigClient;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;

@OnlyIn(value=Dist.CLIENT)
public class RavenousRushEffectOverlay
implements IGuiOverlay {
    private static final ResourceLocation RAVENOUS_RUSH_OVERLAY_LOCATION = new ResourceLocation("dungeonsdelight", "textures/misc/ravenous_rush_overlay.png");
    private static final ResourceLocation VIGNETTE_LOCATION = new ResourceLocation("textures/misc/vignette.png");
    protected int screenWidth;
    protected int screenHeight;

    public void render(ForgeGui forgeGui, GuiGraphics graphics, float v, int i, int i1) {
        this.screenWidth = graphics.m_280182_();
        this.screenHeight = graphics.m_280206_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (((Boolean)DDConfigClient.RAVENOUS_RUSH_OVERLAY.get()).booleanValue() && player != null && !player.m_21023_((MobEffect)DDEffects.VORACITY.get())) {
            this.renderTextureOverlay(graphics, RAVENOUS_RUSH_OVERLAY_LOCATION, this.getPercentMonster((Player)player));
        }
        if (player != null && player.m_21023_((MobEffect)DDEffects.RAVENOUS_RUSH.get())) {
            this.renderVignette(graphics, this.getPercentMonsterVignette((Player)player));
        }
    }

    public float getPercentMonster(Player player) {
        if (player.m_21023_((MobEffect)DDEffects.RAVENOUS_RUSH.get()) && player.m_21124_((MobEffect)DDEffects.RAVENOUS_RUSH.get()).m_19557_() == -1) {
            return 1.0f;
        }
        if (player.m_21023_((MobEffect)DDEffects.RAVENOUS_RUSH.get())) {
            return (float)Math.min(player.m_21124_((MobEffect)DDEffects.RAVENOUS_RUSH.get()).m_19557_(), 200) / 200.0f;
        }
        return 0.0f;
    }

    public float getPercentMonsterVignette(Player player) {
        if (player.m_21124_((MobEffect)DDEffects.RAVENOUS_RUSH.get()).m_19557_() == -1 || player.m_21124_((MobEffect)DDEffects.RAVENOUS_RUSH.get()).m_19557_() >= 80) {
            return 0.4f;
        }
        return (float)(player.m_21124_((MobEffect)DDEffects.RAVENOUS_RUSH.get()).m_19557_() / 2) / 100.0f;
    }

    public void renderVignette(GuiGraphics graphics, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        graphics.m_280246_(0.0f, alpha, alpha, 1.0f);
        graphics.m_280398_(VIGNETTE_LOCATION, 0, 0, -90, 0.0f, 0.0f, this.screenWidth, this.screenHeight, this.screenWidth, this.screenHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
    }

    protected void renderTextureOverlay(GuiGraphics graphics, ResourceLocation resourceLocation, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        graphics.m_280398_(resourceLocation, 0, 0, -90, 0.0f, 0.0f, this.screenWidth, this.screenHeight, this.screenWidth, this.screenHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

