/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.event.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.yirmiri.dungeonsdelight.DDConfigClient;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;

@OnlyIn(value=Dist.CLIENT)
public class VoracityEffectOverlay
implements IGuiOverlay {
    private static final ResourceLocation VORACITY_OVERLAY_LOCATION = new ResourceLocation("dungeonsdelight", "textures/misc/voracity_overlay.png");
    protected int screenWidth;
    protected int screenHeight;

    public void render(ForgeGui forgeGui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        this.screenWidth = graphics.m_280182_();
        this.screenHeight = graphics.m_280206_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (((Boolean)DDConfigClient.VORACITY_OVERLAY.get()).booleanValue() && player != null && player.m_21023_((MobEffect)DDEffects.VORACITY.get())) {
            if (((Boolean)DDConfigClient.VORACITY_TRANSPARENCY.get()).booleanValue()) {
                this.renderTextureOverlay(graphics, VORACITY_OVERLAY_LOCATION, this.getPercentMonster((Player)player) / 2.0f);
            } else {
                this.renderTextureOverlay(graphics, VORACITY_OVERLAY_LOCATION, this.getPercentMonster((Player)player));
            }
        }
    }

    public float getPercentMonster(Player player) {
        if (player.m_21124_((MobEffect)DDEffects.VORACITY.get()).m_19557_() == -1) {
            return 1.0f;
        }
        return (float)Math.min(player.m_21124_((MobEffect)DDEffects.VORACITY.get()).m_19557_(), 200) / 200.0f;
    }

    protected void renderTextureOverlay(GuiGraphics graphics, ResourceLocation resourceLocation, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        graphics.m_280398_(resourceLocation, 0, 0, -90, 0.0f, 0.0f, this.screenWidth, this.screenHeight, this.screenWidth, this.screenHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

