/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.mixin;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.yirmiri.dungeonsdelight.common.entity.misc.CleaverEntity;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamEntity;
import net.yirmiri.dungeonsdelight.common.item.CleaverItem;
import net.yirmiri.dungeonsdelight.common.util.DDUtil;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    LivingEntity living = (LivingEntity)this;
    @Shadow
    private Optional<BlockPos> f_20957_;
    @Unique
    private static Random random = new Random();

    @Shadow
    public abstract ItemStack m_21205_();

    @ModifyVariable(at=@At(value="HEAD"), method={"hurt"}, argsOnly=true)
    public float dungeonsdelight$modifyDamage(float amount) {
        if (this.living.m_21023_((MobEffect)DDEffects.EXUDATION.get()) && this.living.m_6103_() > 0.0f) {
            return amount * 1.5f;
        }
        return amount;
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    private void dungeonsdelight$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        Entity attacker = source.m_7639_();
        if (attacker instanceof Player && (player = (Player)attacker).m_21023_((MobEffect)DDEffects.VORACITY.get())) {
            int voracityLevel = player.m_21124_((MobEffect)DDEffects.VORACITY.get()).m_19564_();
            player.m_36324_().m_38707_(this.getVoracityRefillAmount((LivingEntity)player, amount), 0.3f + (float)voracityLevel / 10.0f);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 1.0f, 1.0f);
            DDUtil.spreadParticles((ParticleOptions)DDParticles.DECISIVE_CRITICAL.get(), (Entity)this.living, random);
        }
        if (this.living instanceof MonsterYamEntity && source.m_269533_(DamageTypeTags.f_268581_)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"createWitherRose"})
    private void dungeonsdelight$createWitherRose(LivingEntity attacker, CallbackInfo ci) {
        if (attacker != null && attacker.m_21023_((MobEffect)DDEffects.VORACITY.get())) {
            attacker.m_7292_(new MobEffectInstance((MobEffect)DDEffects.RAVENOUS_RUSH.get(), 100, 0));
            DDUtil.spreadParticles((ParticleOptions)DDParticles.DECISIVE_CRITICAL.get(), (Entity)this.living, random);
        }
    }

    private int getVoracityRefillAmount(LivingEntity living, float amount) {
        if (amount / 2.0f < 1.0f) {
            return 1;
        }
        if ((float)(living.m_21124_((MobEffect)DDEffects.VORACITY.get()).m_19564_() + 4) > amount) {
            return (int)(amount / 2.0f);
        }
        return living.m_21124_((MobEffect)DDEffects.VORACITY.get()).m_19564_() + 4;
    }

    @Inject(at={@At(value="HEAD")}, method={"isDamageSourceBlocked"}, cancellable=true)
    private void dungeonsdelight$isDamageSourceBlocked(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        if (source.m_7640_() instanceof CleaverEntity) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canDisableShield"}, cancellable=true)
    private void dungeonsdelight$canDisableShield(CallbackInfoReturnable<Boolean> cir) {
        if (this.m_21205_().m_41720_() instanceof CleaverItem) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onClimbable"}, cancellable=true)
    private void dungeonsdelight$onClimbable(CallbackInfoReturnable<Boolean> cir) {
        BlockPos blockpos = this.living.m_20183_();
        if (this.living.m_21023_((MobEffect)DDEffects.POUNCING.get()) && this.living.f_19862_ && !this.living.m_6047_()) {
            this.f_20957_ = Optional.of(blockpos);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void dungeonsdelight$tick(CallbackInfo ci) {
        if (this.living.m_21023_((MobEffect)DDEffects.POUNCING.get()) && this.living.f_19862_ && this.living.m_6047_()) {
            Vec3 movement = this.living.m_20184_();
            if (movement.f_82480_ < -0.37) {
                double deltaMovement = -0.29 / movement.f_82480_;
                this.living.m_20256_(new Vec3(movement.f_82479_ * deltaMovement, -0.29, movement.f_82481_ * deltaMovement));
            } else {
                this.living.m_20256_(new Vec3(movement.f_82479_, -0.29, movement.f_82481_));
            }
            for (int i = 0; i < 5; ++i) {
                this.living.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.living.m_146900_()), this.living.m_20185_(), this.living.m_20186_(), this.living.m_20189_(), 0.0, 0.0, 0.0);
            }
            this.living.m_183634_();
        }
    }
}

