/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDEnchantments;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import net.yirmiri.dungeonsdelight.integration.appledog.ADItems;
import net.yirmiri.dungeonsdelight.integration.twilightforest.TFItems;

public class DDLangGen
extends LanguageProvider {
    public static final String DD_ID = "dungeonsdelight";
    public static final String YT_ID = "yapping_tooltips";
    public static final String NA_DESC = "Yirmiri & Betwixer seem to have forgotten this tooltip D:";

    public DDLangGen(PackOutput output) {
        super(output, DD_ID, "en_us");
    }

    protected void addTranslations() {
        this.add("dungeonsdelight_tab", "Dungeon's Delight");
        this.add("dungeonsdelight_compat_tab", "Dungeon's Delight Compatibility");
        this.add("farmersdelight.container.monster_pot", "Monster Pot");
        this.add("farmersdelight.tooltip.wip", "Warning! This item is currently unfinished and is subject to change...");
        this.add("farmersdelight.jei.monster_cooking", "Monster Cooking");
        this.add("farmersdelight.jei.sculking", "Sculking");
        this.add("dungeonsdelight.jei.sculking.night", "Sped up and can only sculk by moonlight");
        this.add("dungeonsdelight.jei.sculking.spawner", "Sped up by adjacent spawner heat conductors (see below)");
        this.add("dungeonsdelight.jei.sculking.accelerators", "Sped up by adjacent activators (see below)");
        this.add("farmersdelight.jei.info.rock_candy", "Rock candy can be used to capture mobs inside of them by attacking them.");
        this.add("farmersdelight.jei.info.candied_vex", "Obtained by attacking a Vex with rock candy.");
        this.add("farmersdelight.jei.info.candied_silverfish", "Obtained by attacking a Silverfish with rock candy.");
        this.add("farmersdelight.jei.info.cleaver", "Cleavers are lightweight ranged and melee weapons. They can harvest Straw from grasses, and guarantee secondary drops from entities.");
        this.add("farmersdelight.jei.info.rancid_reduction", "Can be thrown to inflict entities with weakness and exudation, rots fully grown crops.");
        this.add("farmersdelight.jei.info.stained_scrap", "Can be obtained by destroying spawner blocks");
        this.add("farmersdelight.tooltip.monster_burger", "Every sin, disease, and unhealthy treat, merged together between two slices of bread...");
        this.add("farmersdelight.tooltip.bubblegunk", "Can be chewed multiple times, makes the consumer hungry");
        this.add("farmersdelight.tooltip.biteable", "Can be eaten multiple times");
        this.add("farmersdelight.tooltip.small_xp", "Grants a small amount of experience");
        this.add("farmersdelight.tooltip.average_xp", "Grants a sizeable amount of experience");
        this.add("farmersdelight.tooltip.large_xp", "Grants a large amount of experience");
        this.add("farmersdelight.tooltip.ossobusco", "Refills any active monster effects");
        this.add("farmersdelight.tooltip.chance_to_not_consume", "Chance to not consume when eaten");
        this.add("farmersdelight.tooltip.sculk_apple", "Instant Health");
        this.add("farmersdelight.tooltip.undead", "Monsterizes one effect if no monster effects are active");
        this.add("farmersdelight.tooltip.bloody_mary", "Monsterizes one effect... at a cost");
        this.add("farmersdelight.tooltip.rancid_reduction", "Can be thrown to rot fully grown crops");
        this.add("farmersdelight.tooltip.small_xp_poison_potato", "Grants a small amount of experience and cures poison");
        this.add("farmersdelight.tooltip.average_xp_poison_potato", "Grants a sizeable amount of experience and cures poison");
        this.add("farmersdelight.tooltip.large_xp_poison_potato", "Grants a large amount of experience and cures poison");
        this.add("farmersdelight.tooltip.spider_bubble_tea", "Amplifies a random level I effect but halves it's duration");
        this.add("farmersdelight.tooltip.spider_bubble_tea_pouncing", "Pouncing II (02:00) if consumer has no level I effects");
        this.add("farmersdelight.tooltip.monster_burger_food", "Monsterizes all effects with monster variants");
        this.add("dungeonsdelight.tooltip.attribute.range", "Throw Range");
        this.add("dungeonsdelight.tooltip.heat_charge", "Heat Charge:");
        this.add("farmersdelight.tooltip.sculk_dogapple", "Instant Health");
        this.add("farmersdelight.tooltip.arcane_chili", "Can be eaten multiple times, grants random effects");
        this.add((Block)DDBlocks.DUNGEON_STOVE.get(), "Dungeon Stove");
        this.add((Block)DDBlocks.MONSTER_POT.get(), "Monster Pot");
        this.add((Block)DDBlocks.WORMWOOD_PLANKS.get(), "Wormwood Planks");
        this.add((Block)DDBlocks.WORMWOOD_MOSAIC.get(), "Wormwood Mosaic");
        this.add((Block)DDBlocks.WORMWOOD_STAIRS.get(), "Wormwood Stairs");
        this.add((Block)DDBlocks.WORMWOOD_MOSAIC_STAIRS.get(), "Wormwood Mosaic Stairs");
        this.add((Block)DDBlocks.WORMWOOD_SLAB.get(), "Wormwood Slab");
        this.add((Block)DDBlocks.WORMWOOD_MOSAIC_SLAB.get(), "Wormwood Mosaic Slab");
        this.add((Block)DDBlocks.WORMWOOD_FENCE.get(), "Wormwood Fence");
        this.add((Block)DDBlocks.WORMWOOD_FENCE_GATE.get(), "Wormwood Fence Gate");
        this.add((Block)DDBlocks.WORMWOOD_DOOR.get(), "Wormwood Door");
        this.add((Block)DDBlocks.WORMWOOD_TRAPDOOR.get(), "Wormwood Trapdoor");
        this.add((Block)DDBlocks.WORMWOOD_BUTTON.get(), "Wormwood Button");
        this.add((Block)DDBlocks.WORMWOOD_PRESSURE_PLATE.get(), "Wormwood Pressure Plate");
        this.add((Block)DDBlocks.WORMROOTS.get(), "Wormroots");
        this.add((Block)DDBlocks.WORMWOOD_CABINET.get(), "Wormwood Cabinet");
        this.add((Block)DDBlocks.EMBEDDED_EGGS.get(), "Embedded Eggs");
        this.add((Block)DDBlocks.HEAP_OF_ANCIENT_EGGS.get(), "Heap of Ancient Eggs");
        this.add((Block)DDBlocks.SCULK_MAYO_BLOCK.get(), "Block of Sculk Mayo");
        this.add((Block)DDBlocks.WORMROOTS_BLOCK.get(), "Block of Wormroots");
        this.add((Block)DDBlocks.ROTBULB_CROP.get(), "Rotbulbling");
        this.add((Block)DDBlocks.ROTBULB_PLANT.get(), "Wild Rotbulb");
        this.add((Block)DDBlocks.ROTBULB_CRATE.get(), "Rotbulb Crate");
        this.add((Block)DDBlocks.STAINED_SCRAP_BLOCK.get(), "Block of Stained Scrap");
        this.add((Block)DDBlocks.STAINED_SCRAP_BARS.get(), "Stained Scrap Bars");
        this.add((Block)DDBlocks.CUT_STAINED_SCRAP.get(), "Cut Stained Scrap");
        this.add((Block)DDBlocks.CUT_STAINED_SCRAP_STAIRS.get(), "Cut Stained Scrap Stairs");
        this.add((Block)DDBlocks.CUT_STAINED_SCRAP_SLAB.get(), "Cut Stained Scrap Slab");
        this.add((Block)DDBlocks.SCULK_TART.get(), "Sculk Tart");
        this.add((Block)DDBlocks.MONSTER_CAKE.get(), "Monster Cake");
        this.add((Block)DDBlocks.SPIDER_PIE.get(), "Spider Pie");
        this.add((Block)DDBlocks.ROTTEN_CROP.get(), "Rotten Crop");
        this.add((Block)DDBlocks.ROTTEN_POTATOES.get(), "Rotten Potatoes");
        this.add((Block)DDBlocks.ROTTEN_TOMATOES.get(), "Rotten Tomatoes");
        this.add((Block)DDBlocks.GUARDIAN_ANGEL_BLOCK.get(), "Guardian Angel");
        this.add((Block)DDBlocks.OSSOBUSCO_BLOCK.get(), "Ossobusco");
        this.add((Block)DDBlocks.GLOW_BERRY_GELATIN_BLOCK.get(), "Glowberry Gelatin");
        this.add((Block)DDBlocks.POISONOUS_POTATO_CRATE.get(), "Poisonous Potato Crate");
        this.add((Block)DDBlocks.ROTTEN_TOMATO_CRATE.get(), "Rotten Tomato Crate");
        this.add((Block)DDBlocks.LIVING_FIRE.get(), "Living Fire");
        this.add((Block)DDBlocks.LIVING_CANDLE.get(), "Living Candle");
        this.add((Block)DDBlocks.ROTTEN_SPAWNER.get(), "Rotten Spawner");
        this.add((Block)DDBlocks.LIVING_CAMPFIRE.get(), "Living Campfire");
        this.add((Block)DDBlocks.LIVING_TORCH.get(), "Living Torch");
        this.add((Block)DDBlocks.LIVING_LANTERN.get(), "Living Lantern");
        this.add((Block)DDBlocks.STAINED_SCRAP_CHAIN.get(), "Stained Scrap Chain");
        this.add((Block)DDBlocks.STAINED_SCRAP_GRATE.get(), "Stained Scrap Grate");
        this.add((Item)DDItems.LOGO_ITEM.get(), "Logo Item");
        this.add((Item)DDItems.STAINED_SCRAP.get(), "Stained Scrap");
        this.add((Item)DDItems.SCULK_POLYP.get(), "Sculk Polyp");
        this.add((Item)DDItems.ANCIENT_EGG.get(), "Ancient Egg");
        this.add((Item)DDItems.FLINT_CLEAVER.get(), "Flint Cleaver");
        this.add((Item)DDItems.IRON_CLEAVER.get(), "Iron Cleaver");
        this.add((Item)DDItems.GOLDEN_CLEAVER.get(), "Golden Cleaver");
        this.add((Item)DDItems.DIAMOND_CLEAVER.get(), "Diamond Cleaver");
        this.add((Item)DDItems.NETHERITE_CLEAVER.get(), "Netherite Cleaver");
        this.add((Item)DDItems.ROTBULB.get(), "Rotbulb");
        this.add((Item)DDItems.GUNK.get(), "Gunk");
        this.add((Item)DDItems.MONSTER_YAM_SPAWN_EGG.get(), "Monster Yam Spawn Egg");
        this.add((Item)DDItems.STAINED_SCRAP_FRAGMENT.get(), "Stained Scrap Fragment");
        this.add((Item)DDItems.STAINED_CLEAVER.get(), "Stained Cleaver");
        this.add((Item)DDItems.STAINED_KNIFE.get(), "Stained Knife");
        this.add((Item)DDItems.SLIME_NOODLES.get(), "Slime Noodles");
        this.add((Item)DDItems.SLIME_BAR.get(), "Slime Slab");
        this.add((Item)DDItems.GHOULASH.get(), "Ghoulash");
        this.add((Item)DDItems.AMETHYST_ROCK_CANDY.get(), "Amethyst Rock Candy");
        this.add((Item)DDItems.CANDIED_SILVERFISH_SUCKER.get(), "Candied Silverfish Sucker");
        this.add((Item)DDItems.CANDIED_VEX_SUCKER.get(), "Candied Vex Sucker");
        this.add((Item)DDItems.SILVERFISH_ABDOMEN.get(), "Silverfish Abdomen");
        this.add((Item)DDItems.GHAST_CALAMARI.get(), "Ghast Calamari");
        this.add((Item)DDItems.FRIED_GHAST_CALAMARI.get(), "Fried Ghast Calamari");
        this.add((Item)DDItems.GHAST_TENTACLE.get(), "Ghast Tentacle");
        this.add((Item)DDItems.SILVERFISH_FRIED_RICE.get(), "Silverfish Fried Rice");
        this.add((Item)DDItems.SPIDER_MEAT.get(), "Spider Meat");
        this.add((Item)DDItems.SPIDER_EXTRACT.get(), "Spider Extract");
        this.add((Item)DDItems.SMOKED_SPIDER_MEAT.get(), "Smoked Spider Meat");
        this.add((Item)DDItems.SPIDER_TANGHULU.get(), "Spider Tanghulu");
        this.add((Item)DDItems.SPIDER_SALMAGUNDI.get(), "Spider Salmagundi");
        this.add((Item)DDItems.MONSTER_BURGER.get(), "The Monster Burger");
        this.add((Item)DDItems.BUBBLEGUNK.get(), "Bubblegunk");
        this.add((Item)DDItems.CLEAVED_ANCIENT_EGG.get(), "Cleaved Ancient Egg");
        this.add((Item)DDItems.SCULK_MAYO.get(), "Sculk Mayo");
        this.add((Item)DDItems.GLOW_BERRY_GELATIN.get(), "Bowl of Glowberry Gelatin");
        this.add((Item)DDItems.ROTTEN_TRIPE.get(), "Rotten Tripe");
        this.add((Item)DDItems.GELLED_SALAD.get(), "Gelled Salad");
        this.add((Item)DDItems.SLICORICE.get(), "Slicorice");
        this.add((Item)DDItems.COB_N_CANDY.get(), "Cob n' Candy");
        this.add((Item)DDItems.BRINED_FLESH.get(), "Brined Flesh");
        this.add((Item)DDItems.GRITTY_FLESH.get(), "Gritty Flesh");
        this.add((Item)DDItems.DEVILISH_EGGS.get(), "Devilish Eggs");
        this.add((Item)DDItems.GHAST_ROLL.get(), "Ghast Roll");
        this.add((Item)DDItems.TOKAYAKI.get(), "Tokayaki");
        this.add((Item)DDItems.SALT_SOAKED_STEW.get(), "Salt Soaked Stew");
        this.add((Item)DDItems.SOAKED_SKEWER.get(), "Soaked Skewer");
        this.add((Item)DDItems.POI.get(), "Poi");
        this.add((Item)DDItems.MONSTER_MUFFIN.get(), "Monster Muffin");
        this.add((Item)DDItems.RANCID_REDUCTION.get(), "Rancid Reduction");
        this.add((Item)DDItems.SCULK_TART_SLICE.get(), "Slice of Sculk Tart");
        this.add((Item)DDItems.MONSTER_CAKE_SLICE.get(), "Slice of Monster Cake");
        this.add((Item)DDItems.OSSOBUSCO.get(), "Bowl of Ossobusco");
        this.add((Item)DDItems.SPIDER_PIE_SLICE.get(), "Slice of Spider Pie");
        this.add((Item)DDItems.SCULK_APPLE.get(), "Sculk Apple");
        this.add((Item)DDItems.SHIOKARA.get(), "Shiokara");
        this.add((Item)DDItems.BLOODY_MARY.get(), "Bloody Mary");
        this.add((Item)DDItems.WARDENZOLA.get(), "Wardenzola");
        this.add((Item)DDItems.WARDENZOLA_CRUMBLES.get(), "Wardenzola Crumbles");
        this.add((Item)DDItems.MALICIOUS_SANDWICH.get(), "Malicious Sandwich");
        this.add((Item)DDItems.TARO_MILK_TEA.get(), "Taro Milk Tea");
        this.add((Item)DDItems.SNIFFER_SHANK.get(), "Raw Sniffer Shank");
        this.add((Item)DDItems.COOKED_SNIFFER_SHANK.get(), "Cooked Sniffer Shank");
        this.add((Item)DDItems.SOFT_SERVE_SNIFFER_EGG.get(), "Soft Serve Sniffer Egg");
        this.add((Item)DDItems.SNIFFERWURST.get(), "Raw Snifferwurst");
        this.add((Item)DDItems.COOKED_SNIFFERWURST.get(), "Cooked Snifferwurst");
        this.add((Item)DDItems.TERRINE_LOAF.get(), "Terrine Loaf");
        this.add((Item)DDItems.GYUDON.get(), "Gyudon");
        this.add((Item)DDItems.GHASTLY_SPIRITS.get(), "Ghastly Spirits");
        this.add((Item)DDItems.OMINOUS_OMELETTE.get(), "Ominous Omelette");
        this.add((Item)DDItems.CREEPERILLA.get(), "Creeperilla");
        this.add((Item)DDItems.SINIGANG.get(), "Sinigang");
        this.add((Item)DDItems.GUNK_ARROW.get(), "Gunk Arrow");
        this.add((Item)DDItems.SNUFFLEDOG.get(), "Snuffledog");
        this.add((Item)DDItems.CHLOROPASTA.get(), "Chloropasta");
        this.add((Item)DDItems.GUARDIAN_ANGEL.get(), "Plate of Guardian Angel");
        this.add((Item)DDItems.CHICKEN_JOCKEY_SANDWICH.get(), "Chicken Jockey Sandwich");
        this.add((Item)DDItems.BLOATED_BAKED_POTATO.get(), "Bloated Baked Potato");
        this.add((Item)DDItems.AU_ROTTEN_POTATOES.get(), "Au Rotten Potatoes");
        this.add((Item)DDItems.POISONOUS_POUTINE.get(), "Poisonous Poutine");
        this.add((Item)DDItems.SPIDER_BUBBLE_TEA.get(), "Spider Bubble Tea");
        this.add((Block)DDBlocks.SPIDER_DONUT.get(), "Spider Donut");
        this.add((Item)ADItems.SCULK_DOGAPPLE.get(), "sculk dogapple");
        this.add((Item)ADItems.SCULK_CATBLUEBERRY.get(), "sculk catblueberry");
        this.add((Item)TFItems.BUG_CHOPS.get(), "Bug Chops");
        this.add((Item)TFItems.FRIED_BUG_CHOPS.get(), "Fried Bug Chops");
        this.add((Item)TFItems.LIVEROOT_BEER.get(), "Liveroot Beer");
        this.add((Item)TFItems.TORCHBERRY_RAISINS.get(), "Torchberry Raisins");
        this.add((Item)TFItems.WILDERNESS_LUNCHEON.get(), "Wilderness Luncheon");
        this.add((Item)TFItems.MAZE_ROLL.get(), "Maze Roll");
        this.add((Item)TFItems.TOWER_BOREITO.get(), "Tower Boreito");
        this.add((Item)TFItems.AURORA_ICE_CREAM.get(), "Aurora Ice Cream");
        this.add((Item)TFItems.MEEF_WELLINGTON.get(), "Meef Wellington");
        this.add((Item)TFItems.BLAZING_BLOOD_SAUSAGE.get(), "Blazing Blood Sausage");
        this.add((Item)TFItems.ARCANE_CHILI.get(), "Arcane Chili");
        this.add((Item)TFItems.HYDRA_FRICASSEE.get(), "Hydra Fricassee");
        this.add((Item)TFItems.TROLLBER_CHUTNEY.get(), "Trollber Chutney");
        this.add((Item)TFItems.SWEETBREAD.get(), "Sweetbread");
        this.add((Item)TFItems.SCALY_FIDDLEHEAD_RISOTTO.get(), "Scaly Fiddlehead Risotto");
        this.add((EntityType)DDEntities.MONSTER_YAM.get(), "Monster Yam");
        this.add((EntityType)DDEntities.CLEAVER.get(), "Cleaver");
        this.add((EntityType)DDEntities.ANCIENT_EGG.get(), "Ancient Egg");
        this.add((EntityType)DDEntities.RANCID_REDUCTION.get(), "Rancid Reduction");
        this.add((Enchantment)DDEnchantments.RICOCHET.get(), "Ricochet");
        this.add((Enchantment)DDEnchantments.SERRATED_STRIKE.get(), "Serrated Strike");
        this.add((Enchantment)DDEnchantments.PERSISTENCE.get(), "Persistence");
        this.add((Enchantment)DDEnchantments.LIFE_GRASP.get(), "Life Grasp");
        this.add((MobEffect)DDEffects.SERRATED.get(), "Serrated");
        this.add((MobEffect)DDEffects.FERAL_BITE.get(), "Feral Bite");
        this.add((MobEffect)DDEffects.RAVENOUS_RUSH.get(), "Ravenous Rush");
        this.add((MobEffect)DDEffects.BURROW_GUT.get(), "Burrow Gut");
        this.add((MobEffect)DDEffects.EXUDATION.get(), "Exudation");
        this.add((MobEffect)DDEffects.POUNCING.get(), "Pouncing");
        this.add((MobEffect)DDEffects.VORACITY.get(), "Voracity");
        this.add((MobEffect)DDEffects.TENACITY.get(), "Tenacity");
        this.add((MobEffect)DDEffects.DECISIVE.get(), "Decisive");
        this.add("effect.dungeonsdelight.burrow_gut.description", "Consumes haste, the user can only eat monster foods but destroying blocks will replenish hunger based on hardness, has a chance to grant ravenous rush which will increase block breaking speed based on duration.");
        this.add("effect.dungeonsdelight.exudation.description", "Consumes absorption, all absorption hearts become Exudation hearts and take 1.25x extra damage but unleash a deadly explosion upon getting damaged.");
        this.add("effect.dungeonsdelight.pouncing.description", "Consumes jump boost, allows the user to climb up blocks when sneaking and grants +5% increased movement speed per level.");
        this.add("effect.dungeonsdelight.voracity.description", "Consumes nourishment, the user can only eat monster foods but attacking mobs causes the user to consume them. Upon consuming a mob fully, the user will receive ravenous rush for a short time.");
        this.add("effect.dungeonsdelight.tenacity.description", "Consumes comfort, the user heals faster based on how close they are to starving (slower when fuller).");
        this.add("effect.dungeonsdelight.decisive.description", "Consumes strength, the user has a chance to deal a critical strike hit that inflicts 1.5x extra damage of the original attack.");
        this.add("effect.dungeonsdelight.feral_bite.description", "The user of this effect can inflict serrated on attacked targets.");
        this.add("effect.dungeonsdelight.serrated.description", "The user of this effect will very slowly take damage, the damage bypasses most forms of protection.");
        this.add("effect.dungeonsdelight.ravenous_rush.description", "Increases the movement speed and attack speed of the user, grants additional effects based on other effects that are active.");
        this.addDamage(DDDamageTypes.DUNGEON_STOVE_BURN, "%1$s was monstrously grilled to perfection", "%1$s was thrown on the grill by The Monstrous Chef %2$s");
        this.addDamage(DDDamageTypes.SKULL_HEART_BLAST, "%1$s was melted by a monstrous blast", "%1$s was melted by the monstrous blast of %2$s");
        this.addDamage(DDDamageTypes.ANCIENT_EGG, "%1$s had their body overtaken by sculk", "%2$s turned %1$s into a sculk cluster");
        this.addDamage(DDDamageTypes.CLEAVER, "%1$s was sliced and diced into a delight", "%2$s sliced and diced %1$s into a delight");
        this.addDamage(DDDamageTypes.SERRATED, "%1$s was left to bleed out their wounds", "%2$s left %1$s to bleed out their wounds");
        this.addDamage(DDDamageTypes.BLOODY_MARY, "%1$s had their entire body monsterized...", "%2$s watched %1$s have their body monsterize before them...");
        this.addDamage(DDDamageTypes.SHATTER, "%1$s was struck in the head with a bottle", "%2$s shattered the head of %1$s with a bottle");
        this.add("subtitles.effect.decisive.crit", "Decisive slicing");
        this.add("subtitles.item.cleaver.flying", "Cleaver wooshing");
        this.add("subtitles.item.cleaver.throw", "Cleaver throws");
        this.add("subtitles.item.cleaver.hit_block", "Cleaver hits block");
        this.add("subtitles.item.cleaver.hit_entity", "Cleaver hits entity");
        this.add("subtitles.item.cleaver.ricochet", "Cleaver ricochets off block");
        this.add("subtitles.item.cleaver.serrated_strike", "Cleaver slices entity");
        this.add("subtitles.entity.monster_yam.ambient", "Monster Yam gurgles");
        this.add("subtitles.entity.monster_yam.hurt", "Monster Yam hurts");
        this.add("subtitles.entity.monster_yam.death", "Monster Yam dies");
        this.add("dungeonsdelight.advancement.root", "Dungeon's Delight");
        this.add("dungeonsdelight.advancement.root.desc", "A world of monsters await you!");
        this.add("dungeonsdelight.advancement.place_monster_pot", "Delicious in a Dungeon");
        this.add("dungeonsdelight.advancement.place_monster_pot.desc", "Put down a Monster Pot and start preparing monstrous meals!");
        this.add("dungeonsdelight.advancement.eat_biteable_food", "Chewy!");
        this.add("dungeonsdelight.advancement.eat_biteable_food.desc", "Biteable foods will allow you to eat from it multiple times and refill it with specific items");
        this.add("dungeonsdelight.advancement.get_stained_scrap", "Heavy Metal");
        this.add("dungeonsdelight.advancement.get_stained_scrap.desc", "Destroy a spawner to obtain a stained scrap, a piece of metal with lively capabilities");
        this.add("dungeonsdelight.advancement.place_dungeon_stove", "Uncaged, Unbound");
        this.add("dungeonsdelight.advancement.place_dungeon_stove.desc", "Place down a dungeon stove which it's flame can heat a monster pot");
        this.add("dungeonsdelight.advancement.eat_monster_food", "Ah, Dungeon Food");
        this.add("dungeonsdelight.advancement.eat_monster_food.desc", "Combine monsters and ingredients together to create your first monster food");
        this.add("dungeonsdelight.advancement.get_slime_noodles", "Creepy Pasta");
        this.add("dungeonsdelight.advancement.get_slime_noodles.desc", "Cut a slab of slime into gooey noodles");
        this.add("dungeonsdelight.advancement.get_sculk_polyp", "Apple of the Earth");
        this.add("dungeonsdelight.advancement.get_sculk_polyp.desc", "Cut a chunk of sculk into a sculk polyp");
        this.add("dungeonsdelight.advancement.place_embedded_eggs", "Won\u2019t Take a Century");
        this.add("dungeonsdelight.advancement.place_embedded_eggs.desc", "Combine eggs into a pile of sculk and let it fester");
        this.add("dungeonsdelight.advancement.obtain_burrow_gut", "Eater of Worlds");
        this.add("dungeonsdelight.advancement.obtain_burrow_gut.desc", "Silverfish foods will allow you to consume blocks by destroying them but only can eat monster foods, transforms the Haste effect");
        this.add("dungeonsdelight.advancement.obtain_voracity", "Don't Starve");
        this.add("dungeonsdelight.advancement.obtain_voracity.desc", "Plated monster foods will allow you to eat monsters alive but only can eat monster foods, transforms the Nourishment effect");
        this.add("dungeonsdelight.advancement.obtain_tenacity", "Struggler");
        this.add("dungeonsdelight.advancement.obtain_tenacity.desc", "Bowled monster foods naturally heal based on how hungry you are, transforms the Comfort effect");
        this.add("dungeonsdelight.advancement.obtain_pouncing", "Eye of The Spider");
        this.add("dungeonsdelight.advancement.obtain_pouncing.desc", "Spider foods will allow you to climb and slide down blocks, transforms the Leaping effect");
        this.add("dungeonsdelight.advancement.obtain_decisive", "Dice Roller");
        this.add("dungeonsdelight.advancement.obtain_decisive.desc", "Stick held monster foods have a chance to land 1.75x critical hits, transforms the Strength effect");
        this.add("dungeonsdelight.advancement.eat_horse", "How Hungry...?");
        this.add("dungeonsdelight.advancement.eat_horse.desc", "Consume an entire horse alive using the voracity effect");
        this.add("dungeonsdelight.advancement.use_cleaver", "Heaven Pierce Her");
        this.add("dungeonsdelight.advancement.use_cleaver.desc", "Throw a Cleaver to pierce and scavenge extra goods from foes");
        this.add("dungeonsdelight.advancement.get_netherite_cleaver", "Cutlery of Apostasy");
        this.add("dungeonsdelight.advancement.get_netherite_cleaver.desc", "Upgrade your cleaver using netherite and prepare to slice and dice like a master chef");
        this.add("dungeonsdelight.advancement.obtain_perception", "I Can See Everything!");
        this.add("dungeonsdelight.advancement.obtain_perception.desc", "Glowing foods allow the user to see other entities through walls");
        this.add("dungeonsdelight.advancement.eat_sculk_food", "Paint the Town Blue");
        this.add("dungeonsdelight.advancement.eat_sculk_food.desc", "Sculk foods grant a varying amount of experience based on the amount of sculk ingredients");
        this.add("dungeonsdelight.advancement.place_rotbulb_crop", "Corpsebloom");
        this.add("dungeonsdelight.advancement.place_rotbulb_crop.desc", "Plant a rotbulbling and prepare for a monstrous harvest");
        this.add("dungeonsdelight.advancement.obtain_exudation", "Evil Up");
        this.add("dungeonsdelight.advancement.obtain_exudation.desc", "Rot foods will make your absorption hearts take additional damage but explode on entities that hit you, transforms the Absorption effect");
        this.add("dungeonsdelight.advancement.eat_bloody_mary", "Bloody Mary Challenge");
        this.add("dungeonsdelight.advancement.eat_bloody_mary.desc", "Consume the disgusting concoction known as a bloody mary");
        this.add("dungeonsdelight.advancement.eat_sniffer_food", "Is It Worth It?");
        this.add("dungeonsdelight.advancement.eat_sniffer_food.desc", "Consume a Sniffer food... you monster");
        this.add("dungeonsdelight.advancement.get_candied_sucker", "Sweet Revenge!");
        this.add("dungeonsdelight.advancement.get_candied_sucker.desc", "Use an amethyst rock candy to imprison a Vex or Silverfish");
        this.add("dungeonsdelight.advancement.eat_ghastly_spirits", "Fizzy Lifting Drink");
        this.add("dungeonsdelight.advancement.eat_ghastly_spirits.desc", "Consume a bottle of Ghastly Spirits, a drink that can help you quickly escape your enemies!");
        this.add("dungeonsdelight.advancement.all_monster_effects", "Monsters Smashed");
        this.add("dungeonsdelight.advancement.all_monster_effects.desc", "Obtain all monster effects at the same time, who's the real monster now?");
        this.add("dungeonsdelight.advancement.use_rancid_reduction", "Things are Grim Indeed...");
        this.add("dungeonsdelight.advancement.use_rancid_reduction.desc", "Use Rancid Reduction to rot a crop");
        this.add("dungeonsdelight.advancement.all_monster_foods", "The Privilege of The Living");
        this.add("dungeonsdelight.advancement.all_monster_foods.desc", "Consume all monster foods and drinks... you monster");
        this.add("dungeonsdelight.advancement.all_knife_mob_drops", "Gastrocryptozoologist");
        this.add("dungeonsdelight.advancement.all_knife_mob_drops.desc", "Obtain all monster knife drops");
        this.add("dungeonsdelight.advancement.all_dungeonsdelight_foods", "Meal of Champions");
        this.add("dungeonsdelight.advancement.all_dungeonsdelight_foods.desc", "Doesn't matter what it is, CONSUME THEM ALL.");
        this.add("enchantment.dungeonsdelight.ricochet.desc", "Thrown cleavers now bounce and don't have a cooldown upon missing an entity, each bounce increases the damage by 1.1x.");
        this.add("enchantment.dungeonsdelight.serrated_strike.desc", "Cleavers inflict serrated onto struck entities causing protection bypassing damage.");
        this.add("enchantment.dungeonsdelight.persistence.desc", "Cleavers deal less damage but when thrown; inflicts slowness onto struck entities and allows the user to pick up cleavers that hit surfaces to refresh their cooldown.");
        this.add("enchantment.dungeonsdelight.retraction.desc", "Cleavers will pull struck entities or items towards the thrower.");
        this.add("enchantment.dungeonsdelight.life_grasp.desc", "Stained Knives and Cleavers will charge their heat meter quicker.");
        this.add("yapping_tooltips.block.dungeonsdelight.monster_pot.desc", "A mysterious cooking utensil that uses the heat of monster spawners to cook delicacies");
        this.add("yapping_tooltips.block.dungeonsdelight.dungeon_stove.desc", "A stove powered by the energy of life that of which can be exploited for some tasty delights");
        this.add("yapping_tooltips.item.dungeonsdelight.slime_bar.desc", "Sticky slime that has been congealed into a malleable block");
        this.add("yapping_tooltips.item.dungeonsdelight.slime_noodles.desc", "Slippery noodles that almost snake and move on their own");
        this.add("yapping_tooltips.item.dungeonsdelight.ghoulash.desc", "The most approachable of monster meals");
        this.add("yapping_tooltips.item.dungeonsdelight.silverfish_abdomen.desc", "Emergency protein that\u2019s rich with minerals!");
        this.add("yapping_tooltips.item.dungeonsdelight.amethyst_rock_candy.desc", "Don\u2019t tell Abigail!");
        this.add("yapping_tooltips.item.dungeonsdelight.candied_vex_sucker.desc", "An even sweeter revenge!");
        this.add("yapping_tooltips.item.dungeonsdelight.candied_silverfish_sucker.desc", "Edible pest control");
        this.add("yapping_tooltips.item.dungeonsdelight.ghast_calamari.desc", "If it weren't for the ring shape it would slip out your hands!");
        this.add("yapping_tooltips.item.dungeonsdelight.fried_ghast_calamari.desc", "A fried snack to enjoy on a journey");
        this.add("yapping_tooltips.item.dungeonsdelight.ghast_tentacle.desc", "Hope you don't mind the slimy texture!");
        this.add("yapping_tooltips.item.dungeonsdelight.silverfish_fried_rice.desc", "It did what now!?!?");
        this.add("yapping_tooltips.item.dungeonsdelight.spider_meat.desc", "The least poisonous parts of the spider");
        this.add("yapping_tooltips.item.dungeonsdelight.spider_extract.desc", "Don\u2019t call it \u201cSpider Milk\u201d!");
        this.add("yapping_tooltips.item.dungeonsdelight.smoked_spider_meat.desc", "Vague hint of acidity, slight hint of crab, and a big chunk of charcoal");
        this.add("yapping_tooltips.item.dungeonsdelight.spider_tanghulu.desc", "You feel an evil presence watching you...");
        this.add("yapping_tooltips.item.dungeonsdelight.spider_salmagundi.desc", "A violent mixture of various spider guts");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_cupboard.desc", "When a house is both hungry and awake, every room becomes a mouth");
        this.add("yapping_tooltips.block.dungeonsdelight.wormroots.desc", "It feels like its tasting you as you grasp it in your hand");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_planks.desc", "Peculiar planks constructed from wormroots");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_mosaic.desc", "Peculiar planks that have been finely chiseled");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_stairs.desc", "Sinister stairs constructed from wormroots");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_mosaic_stairs.desc", "Sinister stairs constructed from wormwood mosaic");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_slab.desc", "Insidious slabs constructed from wormroots");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_mosaic_slab.desc", "Insidious slabs constructed from wormwood mosaic");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_fence.desc", "To keep THEM out or to keep you in...");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_fence_gate.desc", "Can be opened, but who would want to do that...");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_door.desc", "When a house is both hungry and awake, every room becomes a mouth...");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_trapdoor.desc", "This sinister smirk seems to be beckoning you into a trap");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_pressure_plate.desc", "Produces a redstone signal when ANY entity makes contact with it but is pressed down longer the darker it is");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_button.desc", "Can be pushed by players, arrows, and tridents, stays pushed for longer the darker it is");
        this.add("yapping_tooltips.block.dungeonsdelight.wormwood_cabinet.desc", "Place your food in a cool, damp, dark place where no one can find it");
        this.add("yapping_tooltips.item.dungeonsdelight.bubblegunk.desc", "I have come to chew bubblegunk and kick cubes. And I'm all out of bubblegunk.");
        this.add("yapping_tooltips.item.dungeonsdelight.sculk_polyp.desc", "It is still filled with a little experience...");
        this.add("yapping_tooltips.block.dungeonsdelight.embedded_eggs.desc", "Not truly dead, because it is never truly born. A perfect catalyst for flavor");
        this.add("yapping_tooltips.block.dungeonsdelight.heap_of_ancient_eggs.desc", "Souls in stasis or souls unrestrained? What would happen if you had a taste?");
        this.add("yapping_tooltips.item.dungeonsdelight.ancient_egg.desc", "When sculk converts a life that is yet to die, an unimaginable delicacy");
        this.add("yapping_tooltips.item.dungeonsdelight.cleaved_ancient_egg.desc", "An ancient egg pierced of it\u2019s leathery skin");
        this.add("yapping_tooltips.item.dungeonsdelight.sculk_mayo.desc", "A cacophony of rotten eggs and spoiled grapes");
        this.add("yapping_tooltips.item.dungeonsdelight.flint_cleaver.desc", "A crude flint blade, time to slice and dice!");
        this.add("yapping_tooltips.item.dungeonsdelight.iron_cleaver.desc", "A strong iron blade, time to slice and dice!");
        this.add("yapping_tooltips.item.dungeonsdelight.golden_cleaver.desc", "A hasty golden blade, time to slice and dice!");
        this.add("yapping_tooltips.item.dungeonsdelight.diamond_cleaver.desc", "A shimmering diamond blade, time to slice and dice!");
        this.add("yapping_tooltips.item.dungeonsdelight.netherite_cleaver.desc", "A durable netherite blade, time to slice and dice!");
        this.add("yapping_tooltips.item.dungeonsdelight.glowberry_gelatin.desc", "A sweet squishy dish that illuminates your insides");
        this.add("yapping_tooltips.block.dungeonsdelight.glowberry_gelatin_block.desc", "A lantern just isn\u2019t sweet enough");
        this.add("yapping_tooltips.item.dungeonsdelight.rotten_tripe.desc", "Rotten flesh that has been trimmed of the most unsafe spots");
        this.add("yapping_tooltips.item.dungeonsdelight.gelled_salad.desc", "Not really a soup, not really a salad but something all it\u2019s own");
        this.add("yapping_tooltips.block.dungeonsdelight.sculk_mayo_block.desc", "A cubic meter of solid mayonnaise");
        this.add("yapping_tooltips.block.dungeonsdelight.rotbulb_crop.desc", "Spawns in clusters on top of mud underground");
        this.add("yapping_tooltips.block.dungeonsdelight.rotbulb_plant.desc", "Spawns in clusters on top of mud underground");
        this.add("yapping_tooltips.item.dungeonsdelight.rotbulb.desc", "Like biting into a sack of fetid wax");
        this.add("yapping_tooltips.item.dungeonsdelight.gunk.desc", "The purest form of disgust localized within a clump in your hands");
        this.add("yapping_tooltips.item.dungeonsdelight.monster_yam_spawn_egg.desc", "This crop won't let you harvest it so easily...");
        this.add("yapping_tooltips.block.dungeonsdelight.stained_scrap_block.desc", "A metal block constructed from a collection of stained scrap");
        this.add("yapping_tooltips.block.dungeonsdelight.stained_scrap_bars.desc", "Metal bars constructed from stained scrap");
        this.add("yapping_tooltips.block.dungeonsdelight.cut_stained_scrap.desc", "A stained scrap block that has been cut into tiles");
        this.add("yapping_tooltips.block.dungeonsdelight.cut_stained_scrap_stairs.desc", "Metallic stairs constructed from stained scrap");
        this.add("yapping_tooltips.block.dungeonsdelight.cut_stained_scrap_slab.desc", "Metallic slabs constructed from stained scrap");
        this.add("yapping_tooltips.block.dungeonsdelight.rotbulb_crate.desc", "A crate filled to the brim with rotbulbs");
        this.add("yapping_tooltips.item.dungeonsdelight.cob_n_candy.desc", "Careful it will dissolve in water!");
        this.add("yapping_tooltips.item.dungeonsdelight.slicorice.desc", "Rawboy");
        this.add("yapping_tooltips.item.dungeonsdelight.gritty_flesh.desc", "A refined palate can tell where husk flesh comes from just by the natural seasoning");
        this.add("yapping_tooltips.item.dungeonsdelight.brined_flesh.desc", "Gelatinous hunk of meat that slips effortlessly through your fingers");
        this.add("yapping_tooltips.item.dungeonsdelight.devilish_eggs.desc", "A sinister combination of the weirdest smelling egg and the weirdest smelling condiment");
        this.add("yapping_tooltips.item.dungeonsdelight.ghast_roll.desc", "A delicious mixture of ghast and rotbulb");
        this.add("yapping_tooltips.item.dungeonsdelight.tokayaki.desc", "A soft dish filled with some mushy sculk");
        this.add("yapping_tooltips.item.dungeonsdelight.salt_soaked_stew.desc", "The flesh seems to have melted into the broth itself");
        this.add("yapping_tooltips.item.dungeonsdelight.soaked_skewer.desc", "Wet flesh hangs flimsily onto the bone");
        this.add("yapping_tooltips.item.dungeonsdelight.poi.desc", "No one will be a bigger hater than Yirmiri");
        this.add("yapping_tooltips.item.dungeonsdelight.monster_muffin.desc", "Only cowards use yeast");
        this.add("yapping_tooltips.item.dungeonsdelight.rancid_reduction.desc", "A little bottle of monster rot");
        this.add("yapping_tooltips.block.dungeonsdelight.sculk_tart.desc", "Mouth full of souls!");
        this.add("yapping_tooltips.item.dungeonsdelight.sculk_tart_slice.desc", "Slice full of souls!");
        this.add("yapping_tooltips.block.dungeonsdelight.monster_cake.desc", "Sad the monsters aren't around for their own party");
        this.add("yapping_tooltips.item.dungeonsdelight.monster_cake_slice.desc", "A slice of life... literally...");
        this.add("yapping_tooltips.block.dungeonsdelight.ossobusco_block.desc", "Who would think after your fate you'd become a serving dish");
        this.add("yapping_tooltips.item.dungeonsdelight.ossobusco.desc", "Be careful not to eat the bones... unless you want to.");
        this.add("yapping_tooltips.block.dungeonsdelight.spider_pie.desc", "Natural sweeteners");
        this.add("yapping_tooltips.item.dungeonsdelight.spider_pie_slice.desc", "When you want your spider guts on the go!");
        this.add("yapping_tooltips.item.dungeonsdelight.sculk_apple.desc", "An apple that has been candied in sculk");
        this.add("yapping_tooltips.item.dungeonsdelight.shiokara.desc", "A dish filled with the visceral insides of monsters");
        this.add("yapping_tooltips.item.dungeonsdelight.bloody_mary.desc", "\"You swear you saw a silhouette in the reflection of the glass...\"");
        this.add("yapping_tooltips.item.dungeonsdelight.wardenzola.desc", "A block of vile smelling cheese that tastes faintly of raisins");
        this.add("yapping_tooltips.item.dungeonsdelight.wardenzola_crumbles.desc", "The sculk seems to grow just as new parts are exposed to air");
        this.add("yapping_tooltips.item.dungeonsdelight.malicious_sandwich.desc", "Something malicious is brewing...");
        this.add("yapping_tooltips.item.dungeonsdelight.taro_milk_tea.desc", "The milk and sugar seems to cancel out the spoiled rot");
        this.add("yapping_tooltips.item.dungeonsdelight.sniffer_shank.desc", "Only a monster would cut the leg off such a joyful creature");
        this.add("yapping_tooltips.item.dungeonsdelight.cooked_sniffer_shank.desc", "The cooked leg of a once joyful creature");
        this.add("yapping_tooltips.item.dungeonsdelight.soft_serve_sniffer_egg.desc", "Well, I guess the egg comes first");
        this.add("yapping_tooltips.item.dungeonsdelight.snifferwurst.desc", "A raw piece of meat that can regenerate anything but itself");
        this.add("yapping_tooltips.item.dungeonsdelight.cooked_snifferwurst.desc", "A searing piece of delicious meat");
        this.add("yapping_tooltips.item.dungeonsdelight.terrine_loaf.desc", "A horde of every rotten beast congealed into a flavour of unimaginable complexity");
        this.add("yapping_tooltips.item.dungeonsdelight.gyudon.desc", "A challenging meal of grease and protein");
        this.add("yapping_tooltips.item.dungeonsdelight.ghastly_spirits.desc", "The spirits of the sand are free... or just to get caught up in a bottle");
        this.add("yapping_tooltips.item.dungeonsdelight.ominous_omelette.desc", "A peculiar tingling filling wrapped within a shroud of savory eggs");
        this.add("yapping_tooltips.item.dungeonsdelight.creeperilla.desc", "A crunchy leaf-like plant filled with gunpowder, be careful with how you cut");
        this.add("yapping_tooltips.item.dungeonsdelight.sinigang.desc", "Life and death, sweet and sour...");
        this.add("yapping_tooltips.item.dungeonsdelight.gunk_arrow.desc", "An arrow that has been blunted by gunk, the foul spell attracts the undead");
        this.add("yapping_tooltips.item.dungeonsdelight.snuffledog.desc", "Ketchup or mustard?");
        this.add("yapping_tooltips.item.dungeonsdelight.guardian_angel.desc", "All that effort decorating your dish just to smash it onto a plate");
        this.add("yapping_tooltips.item.dungeonsdelight.guardian_angel_block.desc", "Gel in the shape of a guardian... so like... a guardian angel?");
        this.add("yapping_tooltips.item.dungeonsdelight.chicken_jockey_sandwich.desc", "CHICKEN JOCKEY!!!");
        this.add("yapping_tooltips.item.dungeonsdelight.au_rotten_potatoes.desc", "A flower pot full of... a foul stench, yuck");
        this.add("yapping_tooltips.item.dungeonsdelight.bloated_baked_potato.desc", "Bloated to the brim with rich (and mostly disgusting) ingredients");
        this.add("yapping_tooltips.item.dungeonsdelight.poisonous_poutine.desc", "A poisonous mess of rotten and disgusting ingredients");
        this.add("yapping_tooltips.block.dungeonsdelight.poisonous_potato_crate.desc", "A crate filled to the brim with poisonous potatoes");
        this.add("yapping_tooltips.block.dungeonsdelight.rotten_tomato_crate.desc", "A crate filled to the brim with rotten tomatoes");
        this.add("yapping_tooltips.item.dungeonsdelight.spider_bubble_tea.desc", "Don't choke on the eyeballs!");
        this.add("yapping_tooltips.item.dungeonsdelight.chloropasta.desc", "A tasty salad full of slimy noodles");
        this.add("yapping_tooltips.block.dungeonsdelight.rotten_spawner.desc", "All the life energy has been consumed into a new life...");
        this.add("yapping_tooltips.block.dungeonsdelight.living_candle.desc", "Life essence keeps the flame ablaze");
        this.add("yapping_tooltips.block.dungeonsdelight.living_lantern.desc", "Life essence keeps the flame ablaze");
        this.add("yapping_tooltips.block.dungeonsdelight.living_campfire.desc", "A station used to cook up to 4 foods slowly");
        this.add("yapping_tooltips.block.dungeonsdelight.living_torch.desc", "Life essence keeps the flame ablaze");
        this.add("yapping_tooltips.block.dungeonsdelight.stained_scrap_chain.desc", "Metal chains constructed from stained scrap");
        this.add("yapping_tooltips.item.dungeonsdelight.stained_scrap.desc", "A cold slice of metal that has the ability to bring together life");
        this.add("yapping_tooltips.block.dungeonsdelight.spider_donut.desc", "Don't worry, Spider didn't.");
        this.add("yapping_tooltips.item.dungeonsdelight.stained_scrap_fragment.desc", "A fragment of life");
        this.add("yapping_tooltips.block.dungeonsdelight.stained_scrap_grate.desc", "A metallic grate constructed from stained scrap that allows items to pass through it, great!");
        this.add("yapping_tooltips.item.dungeonsdelight.stained_knife.desc", "A stained blade prepared for stealing life essence, time to slice and dice!");
        this.add("yapping_tooltips.item.dungeonsdelight.stained_cleaver.desc", "A stained blade prepared for stealing life essence, time to slice and dice!");
        this.add("yapping_tooltips.item.dungeonsdelight.sculk_dogapple.desc", "goth applog");
        this.add("yapping_tooltips.item.dungeonsdelight.bug_chops.desc", "Tellio's favorite!");
        this.add("yapping_tooltips.item.dungeonsdelight.fried_bug_chops.desc", "Fried bug ready for the tasting");
        this.add("yapping_tooltips.item.dungeonsdelight.liveroot_beer.desc", "Bet it tastes good with ice cream!");
        this.add("yapping_tooltips.item.dungeonsdelight.torchberry_raisins.desc", "Kinda smells like sculk");
        this.add("yapping_tooltips.item.dungeonsdelight.wilderness_luncheon.desc", "A tasty sandwich filled with the immediate wildlife");
        this.add("yapping_tooltips.item.dungeonsdelight.maze_roll.desc", "Bugs and plants rolled up into a treat!");
        this.add("yapping_tooltips.item.dungeonsdelight.tower_boreito.desc", "A burrito filled with the tower's tasty monsters");
        this.add("yapping_tooltips.item.dungeonsdelight.aurora_ice_cream.desc", "The ice cream faintly glows in differing colors");
        this.add("yapping_tooltips.item.dungeonsdelight.meef_wellington.desc", "Is it a sandwich filled with monster meat or minotaur beef?");
        this.add("yapping_tooltips.item.dungeonsdelight.blazing_blood_sausage.desc", "So hot it almost was given fire resistance II");
        this.add("yapping_tooltips.item.dungeonsdelight.arcane_chili.desc", "\"There is no prize to perfection. Only an end to pursuit.\"");
        this.add("yapping_tooltips.item.dungeonsdelight.hydra_fricassee.desc", "An extremely spicy dish filled with dragon meat");
        this.add("yapping_tooltips.item.dungeonsdelight.trollber_chutney.desc", "A jar of glowing mush");
        this.add("yapping_tooltips.item.dungeonsdelight.sweetbread.desc", "A sweet snack for an adventurer's journey");
        this.add("yapping_tooltips.item.dungeonsdelight.scaly_fiddlehead_risotto.desc", "Once a large dangerous snake, now a creamy mix of rice and Naga meat");
    }

    private void addDamage(ResourceKey<DamageType> type, String deathMsg, String killMsg) {
        this.add(type.m_135782_().m_214298_(), deathMsg);
        this.add("death.attack." + type.m_135782_().m_214298_(), deathMsg);
        this.add("death.attack." + type.m_135782_().m_214298_() + ".player", killMsg);
    }
}

