/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.yirmiri.dungeonsdelight.common.block.entity.container.MonsterPotMenu;
import net.yirmiri.dungeonsdelight.common.block.entity.container.MonsterPotScreen;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import net.yirmiri.dungeonsdelight.core.registry.DDMenuTypes;
import net.yirmiri.dungeonsdelight.integration.jei.DDRecipeTypes;
import net.yirmiri.dungeonsdelight.integration.jei.DDRecipes;
import net.yirmiri.dungeonsdelight.integration.jei.category.MonsterPotRecipeCategory;
import net.yirmiri.dungeonsdelight.integration.jei.category.SculkingRecipeCategory;
import vectorwing.farmersdelight.common.utility.TextUtils;
import vectorwing.farmersdelight.integration.jei.resource.DecompositionDummy;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("dungeonsdelight", "jei_plugin");

    public void registerRecipes(IRecipeRegistration registration) {
        DDRecipes modRecipes = new DDRecipes();
        registration.addRecipes(DDRecipeTypes.MONSTER_COOKING, modRecipes.getMonsterPotRecipes());
        registration.addRecipes(DDRecipeTypes.SCULKING, (List)ImmutableList.of((Object)new DecompositionDummy()));
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.STAINED_SCRAP.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.stained_scrap", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.AMETHYST_ROCK_CANDY.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.rock_candy", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.CANDIED_VEX_SUCKER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.candied_vex", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.CANDIED_SILVERFISH_SUCKER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.candied_silverfish", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.FLINT_CLEAVER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.cleaver", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.GOLDEN_CLEAVER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.cleaver", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.IRON_CLEAVER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.cleaver", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.DIAMOND_CLEAVER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.cleaver", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.NETHERITE_CLEAVER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.cleaver", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.STAINED_CLEAVER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.cleaver", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.STAINED_KNIFE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.knife", (Object[])new Object[0])});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)DDItems.RANCID_REDUCTION.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.rancid_reduction", (Object[])new Object[0])});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new MonsterPotRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SculkingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)DDBlocks.MONSTER_POT.get()).m_5456_()), new RecipeType[]{DDRecipeTypes.MONSTER_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)DDBlocks.EMBEDDED_EGGS.get()), new RecipeType[]{DDRecipeTypes.SCULKING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MonsterPotScreen.class, 89, 25, 24, 17, new RecipeType[]{DDRecipeTypes.MONSTER_COOKING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(MonsterPotMenu.class, (MenuType)DDMenuTypes.MONSTER_POT.get(), DDRecipeTypes.MONSTER_COOKING, 0, 6, 9, 36);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

