/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;

public class LivingCandleBlock
extends AbstractCandleBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<LivingCandleBlock> CODEC = LivingCandleBlock.simpleCodec(LivingCandleBlock::new);

    protected MapCodec<? extends AbstractCandleBlock> codec() {
        return CODEC;
    }

    public LivingCandleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected Iterable<Vec3> getParticleOffsets(BlockState state) {
        return Collections.singleton(new Vec3(0.5, 0.8, 0.5));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getAbilities().mayBuild && player.getItemInHand(hand).isEmpty() && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            LivingCandleBlock.extinguish((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return Stream.of(Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }

    public void animateTick(BlockState p_220697_, Level p_220698_, BlockPos p_220699_, RandomSource p_220700_) {
        if (((Boolean)p_220697_.getValue((Property)LIT)).booleanValue()) {
            LivingCandleBlock.addParticlesAndSound(p_220698_, new Vec3(0.5, 0.85, 0.5).add((double)p_220699_.getX(), (double)p_220699_.getY(), (double)p_220699_.getZ()), p_220700_);
        }
    }

    private static void addParticlesAndSound(Level p_220688_, Vec3 p_220689_, RandomSource p_220690_) {
        float f = p_220690_.nextFloat();
        if (f < 0.3f) {
            p_220688_.addParticle((ParticleOptions)ParticleTypes.SMOKE, p_220689_.x, p_220689_.y, p_220689_.z, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                p_220688_.playLocalSound(p_220689_.x + 0.5, p_220689_.y + 0.5, p_220689_.z + 0.5, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + p_220690_.nextFloat(), p_220690_.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        p_220688_.addParticle((ParticleOptions)DDParticles.LIVING_FLAME.get(), p_220689_.x, p_220689_.y, p_220689_.z, 0.0, 0.0, 0.0);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_152803_) {
        FluidState fluidstate = p_152803_.getLevel().getFluidState(p_152803_.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(p_152803_).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState getFluidState(BlockState p_152844_) {
        return (Boolean)p_152844_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_152844_);
    }

    public boolean placeLiquid(LevelAccessor p_152805_, BlockPos p_152806_, BlockState p_152807_, FluidState p_152808_) {
        if (!((Boolean)p_152807_.getValue((Property)WATERLOGGED)).booleanValue() && p_152808_.getType() == Fluids.WATER) {
            BlockState blockstate = (BlockState)p_152807_.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (((Boolean)p_152807_.getValue((Property)LIT)).booleanValue()) {
                LivingCandleBlock.extinguish(null, (BlockState)blockstate, (LevelAccessor)p_152805_, (BlockPos)p_152806_);
            } else {
                p_152805_.setBlock(p_152806_, blockstate, 3);
            }
            p_152805_.scheduleTick(p_152806_, p_152808_.getType(), p_152808_.getType().getTickDelay((LevelReader)p_152805_));
            return true;
        }
        return false;
    }

    public static boolean canLight(BlockState p_152846_) {
        return p_152846_.is(BlockTags.CANDLES, p_152810_ -> p_152810_.hasProperty((Property)LIT) && p_152810_.hasProperty((Property)WATERLOGGED)) && (Boolean)p_152846_.getValue((Property)LIT) == false && (Boolean)p_152846_.getValue((Property)WATERLOGGED) == false;
    }

    protected boolean canBeLit(BlockState p_152842_) {
        return (Boolean)p_152842_.getValue((Property)WATERLOGGED) == false && super.canBeLit(p_152842_);
    }

    public boolean canSurvive(BlockState p_152829_, LevelReader p_152830_, BlockPos p_152831_) {
        return Block.canSupportCenter((LevelReader)p_152830_, (BlockPos)p_152831_.below(), (Direction)Direction.UP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
        p_49915_.add(new Property[]{LIT, WATERLOGGED});
        super.createBlockStateDefinition(p_49915_);
    }
}

