/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.yirmiri.dungeonsdelight.core.init.DDLootTables;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDCriteriaTriggers;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;

public class WormouthBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty FULL = BooleanProperty.create((String)"full");
    public static final BooleanProperty COOLDOWN = BooleanProperty.create((String)"cooldown");
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)3);

    public WormouthBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FULL, (Comparable)Boolean.valueOf(false))).setValue((Property)COOLDOWN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)FULL);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        if (((Boolean)state.getValue((Property)FULL)).booleanValue() && level.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (source.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)state.setValue((Property)FULL, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int currentBites = (Integer)state.getValue((Property)BITES);
        ItemStack heldItem = player.getItemInHand(hand);
        if (!(level.isClientSide || heldItem.getFoodProperties((LivingEntity)player) == null || ((Boolean)state.getValue((Property)FULL)).booleanValue() || ((Boolean)state.getValue((Property)COOLDOWN)).booleanValue())) {
            ResourceKey<LootTable> lootTableId = heldItem.is(DDTags.ItemT.MONSTER_FOODS) && heldItem.is(DDTags.ItemT.WORMOUTH_FAVORITES) && !heldItem.is(DDTags.ItemT.WORMOUTH_BLACKLIST) ? DDLootTables.WORMOUTH_PREFERRED : DDLootTables.WORMOUTH_DISLIKED;
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
            LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableId);
            ObjectArrayList lootData = lootTable.getRandomItems(builder.create(LootContextParamSets.EMPTY), level.random.nextLong());
            if (!lootData.isEmpty()) {
                WormouthBlock.spitItemStack(level, pos.getX(), (double)pos.getY() - 0.6, pos.getZ(), (ItemStack)lootData.get(level.random.nextInt(lootData.size())));
                if (heldItem.hasCraftingRemainingItem()) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)((double)pos.getY() - 0.6), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)heldItem.getCraftingRemainingItem().getItem()));
                }
            }
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                DDCriteriaTriggers.FEED_WORMOUTH.get().trigger(serverPlayer);
            }
            level.playSound(null, pos, DDSounds.MONSTER_YAM_HURT.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.2, 0.1, 0.2, 0.02);
            if (!lootData.isEmpty()) {
                BlockState cooldownState;
                if (currentBites >= 3 && level.random.nextIntBetweenInclusive(1, 2) == 2) {
                    cooldownState = (BlockState)((BlockState)state.setValue((Property)FULL, (Comparable)Boolean.valueOf(true))).setValue((Property)BITES, (Comparable)Integer.valueOf(0));
                } else {
                    cooldownState = (BlockState)((BlockState)state.setValue((Property)COOLDOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)BITES, (Comparable)Integer.valueOf(Math.min(currentBites + 1, 3)));
                    level.scheduleTick(pos, (Block)this, 10);
                }
                level.setBlock(pos, cooldownState, 2);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)cooldownState));
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static void spitItemStack(Level level, double v, double v1, double v2, ItemStack stack) {
        double width = EntityType.ITEM.getWidth();
        double v3 = 1.0 - width;
        double v4 = width / 2.0;
        double v5 = Math.floor(v) + level.random.nextDouble() * v3 + v4;
        double v6 = Math.floor(v1) + level.random.nextDouble() * v3;
        double v7 = Math.floor(v2) + level.random.nextDouble() * v3 + v4;
        while (!stack.isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(level, v5, v6, v7, stack.split(level.random.nextInt(21) + 10));
            itemEntity.setDeltaMovement(level.random.triangle(0.0, 0.005), 0.0, level.random.triangle(0.0, 0.005));
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlock(pos, (BlockState)state.setValue((Property)COOLDOWN, (Comparable)Boolean.valueOf(false)), 2);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FULL, COOLDOWN, BITES});
    }
}

