/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block.food;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;

public class SpiderDonutBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty DONUTS = IntegerProperty.create((String)"donuts", (int)0, (int)4);
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;

    public SpiderDonutBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    public IntegerProperty getServingsProperty() {
        return DONUTS;
    }

    public int getMaxServings() {
        return 4;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
            return switch ((Integer)state.getValue((Property)DONUTS)) {
                case 0 -> Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
                case 1 -> Block.box((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
                case 2 -> Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
                default -> Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0);
            };
        }
        return switch ((Integer)state.getValue((Property)DONUTS)) {
            case 0 -> Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
            case 1 -> Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
            case 2 -> Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
            default -> Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        };
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return level.isClientSide && this.eat((LevelAccessor)level, pos, state, player, player.getUsedItemHand()).consumesAction() ? InteractionResult.SUCCESS : this.eat((LevelAccessor)level, pos, state, player, player.getUsedItemHand());
    }

    protected InteractionResult eat(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)this.getServingsProperty());
        ItemStack heldStack = player.getItemInHand(hand);
        if (!heldStack.is(this.asItem()) && player.canEat(false)) {
            player.getFoodData().eat(3, 0.3f);
            player.addEffect(new MobEffectInstance(DDEffects.POUNCING, 900, 1));
            level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
            if (servings == 0) {
                level.removeBlock(pos, false);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)DONUTS, (Comparable)Integer.valueOf(servings - 1)), 2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && context.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)DONUTS) < this.getMaxServings() || super.canBeReplaced(state, context);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.is((Block)this)) {
            return (BlockState)blockstate.setValue((Property)DONUTS, (Comparable)Integer.valueOf(Math.min((Integer)blockstate.getValue((Property)DONUTS) + 1, this.getMaxServings())));
        }
        for (Direction direction : context.getNearestLookingDirections()) {
            if (direction.getAxis() != Direction.Axis.Y) continue;
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP));
        }
        return null;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)HANGING)).booleanValue()) {
            return facing == Direction.UP && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
        }
        return facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
            return level.getBlockState(pos.above()).isSolid();
        }
        return level.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, DONUTS, HANGING});
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return (Integer)blockState.getValue((Property)this.getServingsProperty());
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

