/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.effect;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

public class ExudationEffect
extends MobEffect {
    private final Holder<MobEffect> normalVariant;

    public ExudationEffect(Holder<MobEffect> normalVariant, MobEffectCategory category, int color, ParticleOptions particle) {
        super(category, color, particle);
        this.normalVariant = normalVariant;
    }

    public ExudationEffect(Holder<MobEffect> normalVariant, MobEffectCategory category, int color) {
        super(category, color);
        this.normalVariant = normalVariant;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void onEffectStarted(LivingEntity living, int amplifier) {
        living.setAbsorptionAmount(Math.max(living.getAbsorptionAmount(), (float)(4 * (1 + amplifier))));
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId()).withStyle(style -> style.withColor(13137346));
    }
}

