/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.misc;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.yirmiri.dungeonsdelight.common.entity.misc.CleaverEntity;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDCriteriaTriggers;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AncientEggEntity
extends ThrowableItemProjectile {
    public AncientEggEntity(EntityType<? extends AncientEggEntity> entityType, Level level) {
        super(entityType, level);
    }

    public AncientEggEntity(Level level, LivingEntity entity) {
        super(DDEntities.ANCIENT_EGG.get(), entity, level);
    }

    public AncientEggEntity(Level level, double x, double y, double z) {
        super(DDEntities.ANCIENT_EGG.get(), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return DDItems.ANCIENT_EGG.get();
    }

    public void handleEntityEvent(byte id) {
        ItemStack entityStack = new ItemStack((ItemLike)this.getDefaultItem());
        if (id == 3) {
            for (int i = 0; i < 12; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, entityStack), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() * 2.0 - 1.0) * 0.1, ((double)this.random.nextFloat() * 2.0 - 1.0) * 0.1 + 0.1, ((double)this.random.nextFloat() * 2.0 - 1.0) * 0.1);
            }
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        Entity entity2 = result.getEntity();
        entity2.hurt(ModDamageTypes.getSimpleDamageSource((Level)this.level(), DDDamageTypes.ANCIENT_EGG), 4.0f);
        if (result.getType() == HitResult.Type.ENTITY && (entity = result.getEntity()) instanceof CleaverEntity) {
            CleaverEntity cleaverEntity = (CleaverEntity)entity;
            if (!this.level().isClientSide && !cleaverEntity.isInGround()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
                cleaverEntity.playSound((SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), 1.0f, 1.0f);
                this.flingDatEgg(DDItems.CLEAVED_ANCIENT_EGG.get().getDefaultInstance(), -0.5f, 0.0f, true);
                this.flingDatEgg(DDItems.CLEAVED_ANCIENT_EGG.get().getDefaultInstance(), 0.5f, 0.0f, false);
                int expOutput = 3 + this.level().random.nextInt(5) + this.level().random.nextInt(5);
                ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (int)expOutput);
                Entity entity3 = cleaverEntity.getOwner();
                if (entity3 instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity3;
                    DDCriteriaTriggers.SICK_THROW_DUDE.get().trigger(player.connection.getPlayer());
                }
                this.discard();
            }
        }
    }

    public boolean canCollideWith(Entity entity) {
        CleaverEntity cleaverEntity;
        if (entity instanceof CleaverEntity && !(cleaverEntity = (CleaverEntity)entity).isInGround()) {
            return true;
        }
        return super.canCollideWith(entity);
    }

    protected boolean canHitEntity(Entity target) {
        if (target instanceof CleaverEntity) {
            return true;
        }
        return super.canHitEntity(target);
    }

    @Nullable
    public ItemEntity flingDatEgg(ItemStack stack, float offsetX, float offsetY, boolean reverse) {
        if (stack.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.level(), this.getX() + (double)offsetX, this.getY() + (double)offsetY, this.getZ(), stack);
        itementity.setDefaultPickUpDelay();
        double velocity = 0.2;
        itementity.setDeltaMovement(reverse ? -velocity : velocity, 0.0, 0.0);
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.level().addFreshEntity((Entity)itementity);
        }
        return itementity;
    }
}

