/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.yirmiri.dungeonsdelight.common.entity.misc.CleaverEntity;

public class CleaverEntityRenderer
extends EntityRenderer<CleaverEntity> {
    private final ItemRenderer itemRenderer;

    public CleaverEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.itemRenderer = ctx.getItemRenderer();
    }

    public void render(CleaverEntity cleaverEntity, float yaw, float ticks, PoseStack stack, MultiBufferSource bufferSource, int i) {
        float shakeTime;
        super.render((Entity)cleaverEntity, yaw, ticks, stack, bufferSource, i);
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)ticks, (float)cleaverEntity.yRotO, (float)cleaverEntity.getYRot()) - 90.0f));
        stack.translate(0.0, 0.2, 0.0);
        if (cleaverEntity.isInGround()) {
            float rotation = -100.0f;
            if (cleaverEntity.blockSide != null) {
                Direction direction = cleaverEntity.blockSide;
                if (direction == Direction.UP) {
                    rotation = -190.0f;
                } else if (direction == Direction.DOWN) {
                    rotation = -10.0f;
                }
            }
            stack.mulPose(Axis.ZP.rotationDegrees(rotation + cleaverEntity.embeddedRotOffset));
            if (cleaverEntity.blockSide != null) {
                if (cleaverEntity.blockSide == Direction.DOWN) {
                    stack.translate(0.0, -0.5, 0.0);
                } else if (cleaverEntity.blockSide != Direction.UP) {
                    stack.translate(0.0, -0.2, 0.0);
                }
            }
            cleaverEntity.spinning = true;
        } else if (cleaverEntity.spinning) {
            float spin = ((float)cleaverEntity.tickCount + ticks) * (Math.min(-60.0f + ((float)cleaverEntity.tickCount + ticks) / 4.0f, -32.0f) >= -32.0f ? 0.0f : Math.min(-60.0f + ((float)cleaverEntity.tickCount + ticks) / 4.0f, -32.0f));
            stack.mulPose(Axis.ZP.rotationDegrees(spin));
        }
        if (cleaverEntity.isInGround() && cleaverEntity.ricochetsLeft == 0 && (shakeTime = (float)cleaverEntity.shakeTime - ticks) > 0.0f) {
            float f10 = -Mth.sin((float)(shakeTime * 1.5f)) * shakeTime;
            stack.translate(0.0, 0.2, 0.0);
            stack.mulPose(Axis.XN.rotationDegrees(f10));
            stack.translate(0.0, -0.2, 0.0);
        }
        this.itemRenderer.render(cleaverEntity.getCleaverStack(), ItemDisplayContext.FIXED, false, stack, bufferSource, i, OverlayTexture.NO_OVERLAY, this.itemRenderer.getModel(cleaverEntity.getCleaverStack().copy(), cleaverEntity.level(), null, cleaverEntity.getId()));
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(CleaverEntity entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

