/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.misc;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;

public class EchoBlastEntity
extends Entity {
    private LivingEntity owner;
    private float damage;
    private double maxRadius;
    private double expansionPerTick;
    private double radius = 0.0;
    private final Set<LivingEntity> hitEntities = new HashSet<LivingEntity>();

    public EchoBlastEntity(EntityType<? extends EchoBlastEntity> type, Level level) {
        super(type, level);
    }

    public EchoBlastEntity(Level level, LivingEntity owner, double maxRadius, float damage, int duration) {
        this(DDEntities.ECHO_BLAST.get(), level);
        this.owner = owner;
        this.maxRadius = maxRadius;
        this.damage = damage;
        this.expansionPerTick = maxRadius / (double)duration;
        this.setPos(owner.getX(), owner.getY(), owner.getZ());
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.radius += this.expansionPerTick;
            this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(this.radius), entity -> entity != this.owner && entity.isAlive() && entity instanceof Monster && !entity.getType().is(DDTags.EntityT.IGNORES_ECHO_BLAST) && !this.hitEntities.contains(entity)).forEach(entity -> {
                this.hitEntities.add((LivingEntity)entity);
                Vec3 normalize = entity.position().subtract(this.position()).normalize();
                double minStrength = 2.5;
                double maxStrength = 4.0;
                double strength = Math.max(minStrength, maxStrength * (1.0 - entity.position().subtract(this.position()).length() / this.radius));
                entity.setDeltaMovement(normalize.x * strength, 0.25, normalize.z * strength);
                entity.hurt(ModDamageTypes.getSimpleDamageSource((Level)this.level(), DDDamageTypes.ECHO_BLAST), this.damage);
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 0));
            });
            if (this.radius >= this.maxRadius) {
                this.discard();
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }
}

