/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.misc;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;

public class RancidReductionEntity
extends ThrowableItemProjectile {
    public RancidReductionEntity(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    public RancidReductionEntity(Level level, LivingEntity entity) {
        super(DDEntities.RANCID_REDUCTION.get(), entity, level);
    }

    public RancidReductionEntity(Level level, double x, double y, double z) {
        super(DDEntities.RANCID_REDUCTION.get(), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return DDItems.RANCID_REDUCTION.get();
    }

    public void handleEntityEvent(byte id) {
        ItemStack entityStack = new ItemStack((ItemLike)this.getDefaultItem());
        if (id == 3) {
            for (int i = 0; i < 12; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, entityStack), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() * 2.0 - 1.0) * 0.1, ((double)this.random.nextFloat() * 2.0 - 1.0) * 0.1 + 0.1, ((double)this.random.nextFloat() * 2.0 - 1.0) * 0.1);
            }
        }
    }

    public void tick() {
        super.tick();
        this.getDeltaMovement();
        Vec3 vec3 = this.getDeltaMovement();
        double vecX = vec3.x;
        double vecY = vec3.y;
        double vecZ = vec3.z;
        for (int i = 0; i < 4; ++i) {
            this.level().addParticle((ParticleOptions)DDParticles.ROTTEN_GLINT.get(), this.getX() - vecX, this.getY() - vecY, this.getZ() - vecZ, -vecX, -vecY, -vecZ);
        }
    }

    public void rotCrop(BlockPos pos, BlockState blockStateNew, Level level, BlockState state) {
        level.setBlock(pos, blockStateNew, 3);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)this, (BlockState)state));
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), DDSounds.RANCID_REDUCTION.get(), SoundSource.BLOCKS, 1.0f, 0.75f);
        RancidReductionEntity.addRotParticles((LevelAccessor)level, pos, 5);
    }

    public void rotCrop(BlockPos pos, Block newBlock, Level level, BlockState state) {
        this.rotCrop(pos, newBlock.defaultBlockState(), level, state);
    }

    public static void addRotParticles(LevelAccessor accessor, BlockPos pos, int i1) {
        BlockState blockstate;
        if (i1 == 0) {
            i1 = 15;
        }
        if (!(blockstate = accessor.getBlockState(pos)).isAir()) {
            double d1;
            double d0 = 0.5;
            if (blockstate.is(Blocks.WATER)) {
                i1 *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.isSolidRender((BlockGetter)accessor, pos)) {
                pos = pos.above();
                i1 *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.getShape((BlockGetter)accessor, pos).max(Direction.Axis.Y);
            }
            accessor.addParticle((ParticleOptions)DDParticles.ROTTEN_GLINT.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            RandomSource randomsource = accessor.getRandom();
            for (int i = 0; i < i1; ++i) {
                double d8;
                double d7;
                double d2 = randomsource.nextGaussian() * 0.02;
                double d3 = randomsource.nextGaussian() * 0.02;
                double d4 = randomsource.nextGaussian() * 0.02;
                double d5 = 0.5 - d0;
                double d6 = (double)pos.getX() + d5 + randomsource.nextDouble() * d0 * 2.0;
                if (accessor.getBlockState(BlockPos.containing((double)d6, (double)(d7 = (double)pos.getY() + randomsource.nextDouble() * d1), (double)(d8 = (double)pos.getZ() + d5 + randomsource.nextDouble() * d0 * 2.0)).below()).isAir()) continue;
                accessor.addParticle((ParticleOptions)DDParticles.ROTTEN_GLINT.get(), d6, d7, d8, d2, d3, d4);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        entity.hurt(ModDamageTypes.getSimpleDamageSource((Level)this.level(), DDDamageTypes.SHATTER), 3.0f);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        this.level().addParticle((ParticleOptions)DDParticles.SKULL_HEART_BLAST.get(), this.getX(), this.getY(), this.getZ(), 0.0, 0.5, 0.0);
        if (!this.level().isClientSide) {
            this.makeAreaOfEffectCloud();
            this.discard();
        }
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity owner = this.getOwner();
        if (owner instanceof LivingEntity) {
            cloud.setOwner((LivingEntity)owner);
        }
        cloud.setDuration(1);
        cloud.setRadius(3.0f);
        cloud.setRadiusOnUse(-0.5f);
        cloud.setWaitTime(10);
        cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
        cloud.addEffect(new MobEffectInstance(DDEffects.RAVENOUS_RUSH, 0, 0));
        Level level = this.level();
        BlockPos centerPos = new BlockPos((int)Math.floor(cloud.getX()), (int)Math.floor(cloud.getY()), (int)Math.floor(cloud.getZ()));
        this.playSound(SoundEvents.GLASS_BREAK, 1.5f, -1.0f);
        if (!level.isClientSide) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    block7: for (int dz = -1; dz <= 1; ++dz) {
                        pos.set(centerPos.getX() + dx, centerPos.getY() + dy, centerPos.getZ() + dz);
                        BlockState state = level.getBlockState((BlockPos)pos);
                        Block block = state.getBlock();
                        Objects.requireNonNull(block);
                        int n = 0;
                        block8: while (true) {
                            Block block2;
                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PumpkinBlock.class, CarvedPumpkinBlock.class, CropBlock.class}, (Object)block2, n)) {
                                case 0: {
                                    PumpkinBlock pumpkinBlock = (PumpkinBlock)block2;
                                    this.rotCrop((BlockPos)pos, DDBlocks.ROTGOURD.get(), level, state);
                                    continue block7;
                                }
                                case 1: {
                                    CarvedPumpkinBlock carvedPumpkinBlock = (CarvedPumpkinBlock)block2;
                                    if (state.is(Blocks.JACK_O_LANTERN)) {
                                        this.rotCrop((BlockPos)pos, (BlockState)DDBlocks.LIVING_JACK_O_LANTERN.get().defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)((Direction)state.getValue((Property)CarvedPumpkinBlock.FACING))), level, state);
                                        continue block7;
                                    }
                                    this.rotCrop((BlockPos)pos, (BlockState)DDBlocks.CARVED_ROTGOURD.get().defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)((Direction)state.getValue((Property)CarvedPumpkinBlock.FACING))), level, state);
                                    continue block7;
                                }
                                case 2: {
                                    CropBlock cropBlock = (CropBlock)block2;
                                    if (!cropBlock.isMaxAge(state)) {
                                        n = 3;
                                        continue block8;
                                    }
                                    if (block instanceof PotatoBlock) {
                                        this.rotCrop((BlockPos)pos, DDBlocks.ROTTEN_POTATOES.get(), level, state);
                                        continue block7;
                                    }
                                    if (block instanceof TomatoVineBlock) {
                                        TomatoVineBlock tomatoVineBlock = (TomatoVineBlock)block;
                                        if (((Boolean)state.getValue((Property)TomatoVineBlock.ROPELOGGED)).booleanValue()) continue block7;
                                        this.rotCrop((BlockPos)pos, DDBlocks.ROTTEN_TOMATOES.get(), level, state);
                                        continue block7;
                                    }
                                    this.rotCrop((BlockPos)pos, DDBlocks.ROTTEN_CROP.get(), level, state);
                                    continue block7;
                                }
                                default: {
                                    continue block7;
                                }
                            }
                            break;
                        }
                    }
                }
            }
        }
        this.level().addFreshEntity((Entity)cloud);
    }
}

