/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item;

import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.entity.misc.CleaverEntity;
import net.yirmiri.dungeonsdelight.common.util.DDUtil;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import net.yirmiri.dungeonsdelight.datagen.DDEnchantments;
import vectorwing.farmersdelight.common.item.KnifeItem;

public class CleaverItem
extends KnifeItem {
    public final float range;
    public final float attackDamage;

    public CleaverItem(float range, Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, properties.attributes(CleaverItem.createAttributes((Tier)tier, (float)attackDamage, (float)attackSpeed)));
        this.range = range;
        this.attackDamage = attackDamage;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        super.hurtEnemy(stack, target, attacker);
        int serratedStrikeLevel = EnchantmentHelper.getItemEnchantmentLevel(DDUtil.getEnchantmentHolder((Entity)target, DDEnchantments.SERRATED_STRIKE), (ItemStack)stack);
        if (serratedStrikeLevel > 0) {
            int duration = 40 + serratedStrikeLevel * 20;
            if (target.hasEffect(DDEffects.SERRATED)) {
                duration /= 2;
                duration += target.getEffect(DDEffects.SERRATED).getDuration();
            }
            target.addEffect(new MobEffectInstance(DDEffects.SERRATED, duration, 0));
            target.playSound(DDSounds.CLEAVER_SERRATED_STRIKE.get(), 2.0f, target.level().random.nextFloat() * 0.1f + 0.9f);
        }
        if (stack.is(DDTags.ItemT.FLAMING_KNIVES)) {
            target.setRemainingFireTicks(target.getRemainingFireTicks() + 80);
        }
        return true;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public static float getPowerForTime(int charge) {
        float v = (float)charge / 20.0f;
        if ((v = (v * v + v * 2.0f) / 3.0f) > 1.0f) {
            v = 1.0f;
        }
        return v;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void onUseTick(Level level, LivingEntity living, ItemStack stack, int timeLeft) {
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        int usedTicks = this.getUseDuration(stack, living) - timeLeft;
        if (usedTicks == 32) {
            level.playSound(null, (Entity)player, DDSounds.CLEAVER_READY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        super.onUseTick(level, living, stack, timeLeft);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity living, int timeLeft) {
        float fullyCharged = CleaverItem.getPowerForTime(32);
        float threeQuarterCharged = CleaverItem.getPowerForTime(24);
        float halfCharged = CleaverItem.getPowerForTime(16);
        float quarterCharged = CleaverItem.getPowerForTime(8);
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        if (this.getUseDuration(stack, living) - timeLeft < 6 || player.getCooldowns().isOnCooldown((Item)this)) {
            return;
        }
        if (!level.isClientSide) {
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            }
            CleaverEntity cleaver = new CleaverEntity(level, (LivingEntity)player, stack.copy());
            cleaver.setItem(stack.copy());
            this.applyEffects((LivingEntity)player, stack, cleaver);
            cleaver.setBaseDamage(cleaver.getBaseDamage() + (double)this.attackDamage + (double)this.getTier().getAttackDamageBonus());
            float charge = CleaverItem.getPowerForTime(this.getUseDuration(stack, living) - timeLeft);
            float scale = charge / threeQuarterCharged;
            float velocity = this.range * scale;
            float maxVelocity = this.range * (fullyCharged / threeQuarterCharged);
            velocity = Math.min(velocity, maxVelocity);
            if (charge >= fullyCharged) {
                cleaver.setFullyCharged(true);
                cleaver.setMissCooldown(25);
                cleaver.setBaseDamage(cleaver.getBaseDamage() + 0.75);
            } else {
                cleaver.setMissCooldown(50);
            }
            cleaver.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, this.range, 1.0f);
            if (player.getAbilities().instabuild) {
                cleaver.pickup = AbstractArrow.Pickup.DISALLOWED;
            }
            level.addFreshEntity((Entity)cleaver);
            cleaver.setOwner((Entity)player);
            level.playSound(null, (Entity)cleaver, DDSounds.CLEAVER_THROW.get(), SoundSource.PLAYERS, 1.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    public void applyEffects(LivingEntity player, ItemStack stack, CleaverEntity cleaver) {
        int serrated;
        int ricochet;
        int fireAspect;
        int sharpness = EnchantmentHelper.getItemEnchantmentLevel(DDUtil.getEnchantmentHolder((Entity)player, (ResourceKey<Enchantment>)Enchantments.SHARPNESS), (ItemStack)stack);
        if (sharpness > 0) {
            cleaver.setBaseDamage(cleaver.getBaseDamage() + (double)sharpness * 0.5 + 0.5);
        }
        if ((fireAspect = EnchantmentHelper.getItemEnchantmentLevel(DDUtil.getEnchantmentHolder((Entity)player, (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT), (ItemStack)stack)) > 0) {
            cleaver.setRemainingFireTicks(100 * fireAspect);
        }
        if (stack.is(DDTags.ItemT.FLAMING_KNIVES)) {
            cleaver.setRemainingFireTicks(cleaver.getRemainingFireTicks() + 80);
        }
        if ((ricochet = EnchantmentHelper.getItemEnchantmentLevel(DDUtil.getEnchantmentHolder((Entity)player, DDEnchantments.RICOCHET), (ItemStack)stack)) > 0) {
            cleaver.ricochetsLeft += ricochet;
        }
        if ((serrated = EnchantmentHelper.getItemEnchantmentLevel(DDUtil.getEnchantmentHolder((Entity)player, DDEnchantments.SERRATED_STRIKE), (ItemStack)stack)) > 0) {
            cleaver.setSerratedLevel(serrated);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getDamageValue() >= stack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }
}

