/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food_type;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.item.food_type.SculkFoodItem;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SculkFruitItem
extends SculkFoodItem {
    private final boolean hasFoodEffectTooltip;
    private final boolean hasCustomTooltip;
    private final boolean smallFood;

    public SculkFruitItem(Item.Properties properties, int level, boolean hasFoodEffectTooltip, boolean hasCustomTooltip, boolean smallFood) {
        super(properties, level, hasFoodEffectTooltip);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.hasCustomTooltip = hasCustomTooltip;
        this.smallFood = smallFood;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        super.finishUsingItem(stack, level, living);
        if (!level.isClientSide && living instanceof Player) {
            Player player = (Player)living;
            player.playSound(SoundEvents.SCULK_CATALYST_BLOOM);
            if (this.smallFood) {
                player.heal(2.0f);
            } else {
                player.heal(4.0f);
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        if (this.smallFood) {
            return 32;
        }
        return 64;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (this.hasCustomTooltip) {
                MutableComponent textEmpty = TextUtils.getTranslation((String)("tooltip." + String.valueOf((Object)this)), (Object[])new Object[0]);
                tooltip.add((Component)textEmpty.withStyle(ChatFormatting.BLUE));
            }
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)ctx.tickRate());
            }
        }
    }
}

