/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food_type;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SpiderBubbleTeaItem
extends DrinkableItem {
    public SpiderBubbleTeaItem(Item.Properties properties, boolean hasFoodEffectTooltip) {
        super(properties, hasFoodEffectTooltip, false);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        super.finishUsingItem(stack, level, living);
        if (!level.isClientSide) {
            if (!living.getActiveEffects().isEmpty()) {
                ArrayList effectList = new ArrayList(living.getActiveEffects());
                MobEffectInstance randomEffect = (MobEffectInstance)effectList.get(level.getRandom().nextInt(effectList.size()));
                if (randomEffect.getAmplifier() == 0) {
                    living.removeEffect(randomEffect.getEffect());
                    living.addEffect(new MobEffectInstance(randomEffect.getEffect(), randomEffect.getDuration() / 2, 1));
                } else {
                    living.addEffect(new MobEffectInstance(DDEffects.POUNCING, 2400, 1));
                }
            } else {
                living.addEffect(new MobEffectInstance(DDEffects.POUNCING, 2400, 1));
            }
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.spider_bubble_tea", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.spider_bubble_tea_pouncing", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            super.appendHoverText(stack, ctx, tooltip, isAdvanced);
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_DRINK;
    }
}

