/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food_type;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.util.DDUtil;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class UndeadFoodItem
extends ConsumableItem {
    public UndeadFoodItem(Item.Properties properties, boolean hasFoodEffectTooltip) {
        super(properties, hasFoodEffectTooltip, false);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        if (!level.isClientSide && living instanceof Player) {
            Player player = (Player)living;
            if (DDUtil.MONSTER_EFFECTS.stream().noneMatch(arg_0 -> ((Player)player).hasEffect(arg_0))) {
                for (int i = 0; i < DDUtil.NORMAL_EFFECTS.size(); ++i) {
                    if (!player.hasEffect(DDUtil.NORMAL_EFFECTS.get(i))) continue;
                    DDUtil.applyMonsterEffectSwap((LivingEntity)player, DDUtil.NORMAL_EFFECTS.get(i), DDUtil.MONSTER_EFFECTS.get(i));
                    player.playSound(SoundEvents.ZOMBIE_VILLAGER_CONVERTED, 1.0f, 0.5f);
                    break;
                }
            }
        }
        super.finishUsingItem(stack, level, living);
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.undead", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            super.appendHoverText(stack, ctx, tooltip, isAdvanced);
        }
    }
}

