/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.event;

import net.azurune.runiclib.core.platform.services.RLRegistryHelper;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.yirmiri.dungeonsdelight.DDConfigCommon;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamEntity;
import net.yirmiri.dungeonsdelight.common.entity.zombified_dryad.ZombifiedDryadEntity;
import net.yirmiri.dungeonsdelight.common.util.misc.TrialSpawnerFlameParticleAccessor;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import net.yirmiri.dungeonsdelight.integration.content.twilightforest.TFItems;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DDSetupEvents {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        DDSetupEvents.registerDispenserBehaviors();
        DDSetupEvents.registerFlammables();
        DDSetupEvents.registerCompostables();
        if (((Boolean)DDConfigCommon.TRIAL_SPAWNERS_EMIT_GREEN_FLAMES.get()).booleanValue()) {
            DDSetupEvents.setTrialFlameParticleType(TrialSpawner.FlameParticle.NORMAL, DDParticles.LIVING_FLAME.get());
            DDSetupEvents.setTrialFlameParticleType(TrialSpawner.FlameParticle.OMINOUS, DDParticles.SPIRIT_FLAME.get());
        }
    }

    public static void setTrialFlameParticleType(TrialSpawner.FlameParticle particle, SimpleParticleType newParticle) {
        ((TrialSpawnerFlameParticleAccessor)particle).setParticleType(newParticle);
    }

    @SubscribeEvent
    public static void blockEntityAddBlocks(BlockEntityTypeAddBlocksEvent event) {
        event.modify((BlockEntityType)ModBlockEntityTypes.CABINET.get(), new Block[]{DDBlocks.WORMWOOD_CABINET.get()});
    }

    public static void registerCompostables() {
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.ROTBULB_CROP.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.ROTBULB.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.GUNK.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.ROTBULB_PLANT.get()), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.SCULK_TART_SLICE.get()), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDBlocks.SCULK_TART.get()), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.MONSTER_CAKE_SLICE.get()), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.POLTERGHAST_PIZZA_SLICE.get()), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.MONSTER_CAKE.get()), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.MONSTER_MUFFIN.get()), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.SPIDER_DONUT.get()), 0.85f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)DDItems.ROTGOURD_SLICE.get()), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)TFItems.TORCHBERRY_RAISINS.get()), 0.3f);
    }

    public static void registerFlammables() {
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMROOTS_BLOCK.get(), (int)5, (int)5);
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMWOOD_PLANKS.get(), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMWOOD_STAIRS.get(), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMWOOD_SLAB.get(), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMWOOD_FENCE.get(), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMWOOD_FENCE_GATE.get(), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMWOOD_MOSAIC.get(), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMWOOD_MOSAIC_STAIRS.get(), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMWOOD_MOSAIC_SLAB.get(), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMROOT_TENDRILS.get(), (int)15, (int)100);
        RLRegistryHelper.createFlammable((Block)DDBlocks.ROTBULB_PLANT.get(), (int)60, (int)100);
        RLRegistryHelper.createFlammable((Block)DDBlocks.WORMROOT_STALK.get(), (int)10, (int)40);
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)DDItems.ANCIENT_EGG.get()));
        DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)DDItems.RANCID_REDUCTION.get()));
    }

    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(DDEntities.MONSTER_YAM.get(), MonsterYamEntity.createAttributes().build());
        event.put(DDEntities.ZOMBIFIED_DRYAD.get(), ZombifiedDryadEntity.createAttributes().build());
    }
}

