/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.event.overlay.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.azurune.runiclib.RunicLib;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.yirmiri.dungeonsdelight.DDConfigClient;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;

@OnlyIn(value=Dist.CLIENT)
public class RavenousRushEffectOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation RAVENOUS_RUSH_OVERLAY_LOCATION = RunicLib.customid((String)"dungeonsdelight", (String)"textures/misc/ravenous_rush_overlay.png");
    private static final ResourceLocation VIGNETTE_LOCATION = RunicLib.customid((String)"minecraft", (String)"textures/misc/vignette.png");
    protected int screenWidth;
    protected int screenHeight;

    public void render(GuiGraphics graphics, DeltaTracker delta) {
        this.screenWidth = graphics.guiWidth();
        this.screenHeight = graphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        if (((Boolean)DDConfigClient.RAVENOUS_RUSH_OVERLAY.get()).booleanValue() && !Minecraft.getInstance().isPaused() && player != null && !player.hasEffect(DDEffects.VORACITY)) {
            this.renderTextureOverlay(graphics, RAVENOUS_RUSH_OVERLAY_LOCATION, this.getPercentMonster((Player)player));
        }
        if (player != null && player.hasEffect(DDEffects.RAVENOUS_RUSH)) {
            this.renderVignette(graphics, this.getPercentMonsterVignette((Player)player));
        }
    }

    public float getPercentMonster(Player player) {
        if (player.hasEffect(DDEffects.RAVENOUS_RUSH) && player.getEffect(DDEffects.RAVENOUS_RUSH).getDuration() == -1) {
            return 1.0f;
        }
        if (player.hasEffect(DDEffects.RAVENOUS_RUSH)) {
            return (float)Math.min(player.getEffect(DDEffects.RAVENOUS_RUSH).getDuration(), 200) / 200.0f;
        }
        return 0.0f;
    }

    public float getPercentMonsterVignette(Player player) {
        if (player.getEffect(DDEffects.RAVENOUS_RUSH).getDuration() == -1 || player.getEffect(DDEffects.RAVENOUS_RUSH).getDuration() >= 80) {
            return 0.4f;
        }
        return (float)(player.getEffect(DDEffects.RAVENOUS_RUSH).getDuration() / 2) / 100.0f;
    }

    public void renderVignette(GuiGraphics graphics, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        graphics.setColor(0.0f, alpha, alpha, 1.0f);
        graphics.blit(VIGNETTE_LOCATION, 0, 0, -90, 0.0f, 0.0f, this.screenWidth, this.screenHeight, this.screenWidth, this.screenHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
    }

    protected void renderTextureOverlay(GuiGraphics graphics, ResourceLocation resourceLocation, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        graphics.blit(resourceLocation, 0, 0, -90, 0.0f, 0.0f, this.screenWidth, this.screenHeight, this.screenWidth, this.screenHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

