/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.event.overlay.effect;

import com.mojang.blaze3d.systems.RenderSystem;
import net.azurune.runiclib.RunicLib;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.yirmiri.dungeonsdelight.DDConfigClient;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;

@OnlyIn(value=Dist.CLIENT)
public class VoracityEffectOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation VORACITY_OVERLAY_LOCATION = RunicLib.customid((String)"dungeonsdelight", (String)"textures/misc/voracity_overlay.png");
    protected int screenWidth;
    protected int screenHeight;

    public void render(GuiGraphics graphics, DeltaTracker delta) {
        this.screenWidth = graphics.guiWidth();
        this.screenHeight = graphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        if (((Boolean)DDConfigClient.VORACITY_OVERLAY.get()).booleanValue() && !Minecraft.getInstance().isPaused() && player != null && player.hasEffect(DDEffects.VORACITY)) {
            if (((Boolean)DDConfigClient.VORACITY_TRANSPARENCY.get()).booleanValue()) {
                this.renderTextureOverlay(graphics, VORACITY_OVERLAY_LOCATION, this.getPercentMonster((Player)player) / 2.0f);
            } else {
                this.renderTextureOverlay(graphics, VORACITY_OVERLAY_LOCATION, this.getPercentMonster((Player)player));
            }
        }
    }

    public float getPercentMonster(Player player) {
        if (player.getEffect(DDEffects.VORACITY).getDuration() == -1) {
            return 1.0f;
        }
        return (float)Math.min(player.getEffect(DDEffects.VORACITY).getDuration(), 200) / 200.0f;
    }

    protected void renderTextureOverlay(GuiGraphics graphics, ResourceLocation resourceLocation, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        graphics.blit(resourceLocation, 0, 0, -90, 0.0f, 0.0f, this.screenWidth, this.screenHeight, this.screenWidth, this.screenHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

