/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.mixin;

import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamEntity;
import net.yirmiri.dungeonsdelight.common.item.CleaverItem;
import net.yirmiri.dungeonsdelight.common.util.DDUtil;
import net.yirmiri.dungeonsdelight.common.util.misc.RottenHeartData;
import net.yirmiri.dungeonsdelight.common.util.misc.RottenHeartManager;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDCriteriaTriggers;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.registry.ModEffects;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    LivingEntity living = (LivingEntity)this;
    @Shadow
    private Optional<BlockPos> lastClimbablePos;
    @Unique
    private static Random random = new Random();
    private static final Map<Holder<MobEffect>, Holder<MobEffect>> NORMAL_TO_MONSTER = Map.of(MobEffects.DAMAGE_BOOST, DDEffects.DECISIVE, MobEffects.JUMP, DDEffects.POUNCING, MobEffects.ABSORPTION, DDEffects.EXUDATION, ModEffects.NOURISHMENT, DDEffects.VORACITY, ModEffects.COMFORT, DDEffects.TENACITY, MobEffects.DIG_SPEED, DDEffects.BURROW_GUT, MobEffects.MOVEMENT_SPEED, DDEffects.SWIFT_STEP, MobEffects.REGENERATION, DDEffects.ROTGUT);

    @Shadow
    public abstract ItemStack getMainHandItem();

    @Shadow
    public abstract void remove(Entity.RemovalReason var1);

    @ModifyVariable(at=@At(value="HEAD"), method={"hurt"}, argsOnly=true)
    public float dungeonsdelight$modifyDamage(float amount) {
        if (this.living.hasEffect(DDEffects.EXUDATION) && this.living.getAbsorptionAmount() > 0.0f) {
            return amount * 1.5f;
        }
        return amount;
    }

    @Inject(at={@At(value="HEAD")}, method={"tickEffects"})
    private void dungeonsdelight$tickEffects(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)livingEntityMixin;
            for (Map.Entry entry : NORMAL_TO_MONSTER.entrySet()) {
                Holder normal = (Holder)entry.getKey();
                Holder monster = (Holder)entry.getValue();
                MobEffectInstance normalInstance = living.getEffect(normal);
                MobEffectInstance monsterInstance = living.getEffect(monster);
                if (normalInstance == null || monsterInstance == null) continue;
                if (normalInstance.getDuration() >= monsterInstance.getDuration()) {
                    MobEffectInstance newMonster = new MobEffectInstance(monster, normalInstance.getDuration(), 0, monsterInstance.isAmbient(), monsterInstance.isVisible(), monsterInstance.showIcon());
                    living.addEffect(newMonster);
                }
                living.removeEffect(normal);
                if (!(living instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)living;
                DDCriteriaTriggers.MONSTERIZE_EFFECT.get().trigger(serverPlayer);
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setHealth"})
    private void dungeonsdelight$setHealth(float health, CallbackInfo ci) {
        RottenHeartData data = RottenHeartManager.get(this.living);
        if (data == null) {
            return;
        }
        int rotten = data.getRottenHearts();
        if (rotten <= 0) {
            return;
        }
        int allowedRottenHearts = LivingEntityMixin.getAllowedRottenHearts(this.living.getEffect(DDEffects.ROTGUT), this.living.getMaxHealth(), this.living.getHealth());
        if (rotten > allowedRottenHearts) {
            data.setRottenHearts(allowedRottenHearts);
            RottenHeartManager.save(this.living);
        }
    }

    private static int getAllowedRottenHearts(MobEffectInstance rotgut, float maxHealth, float currentHealth) {
        int maxRottenHearts = 8 + (rotgut != null ? (rotgut.getAmplifier() + 1) * 2 : 0);
        int maxHealthHearts = Mth.ceil((float)(maxHealth / 2.0f));
        int currentHealthHearts = Mth.ceil((float)(currentHealth / 2.0f));
        int emptyContainers = Math.max(0, maxHealthHearts - currentHealthHearts);
        return Math.min(maxRottenHearts, emptyContainers * 2);
    }

    @Inject(at={@At(value="TAIL")}, method={"hurt"}, cancellable=true)
    private void dungeonsdelight$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        Entity attacker = source.getEntity();
        if (attacker instanceof Player && (player = (Player)attacker).hasEffect(DDEffects.VORACITY)) {
            int voracityLevel = player.getEffect(DDEffects.VORACITY).getAmplifier();
            player.getFoodData().eat(this.getVoracityRefillAmount((LivingEntity)player, amount), 0.3f + (float)voracityLevel / 10.0f);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 1.0f, 1.0f);
            DDUtil.spreadParticles((ParticleOptions)DDParticles.DECISIVE_CRITICAL.get(), (Entity)this.living, random);
        }
        if (this.living instanceof MonsterYamEntity && (source.is(DamageTypeTags.IS_DROWNING) || source.is(DamageTypes.IN_WALL))) {
            cir.setReturnValue((Object)false);
        }
        if (this.living.hasEffect(DDEffects.ROTGUT)) {
            RottenHeartData data = RottenHeartManager.get(this.living);
            MobEffectInstance rotgut = this.living.getEffect(DDEffects.ROTGUT);
            int maxRottenHearts = 8 + (rotgut != null ? (rotgut.getAmplifier() + 1) * 2 : 0);
            int maxHealthBars = Mth.ceil((float)(this.living.getMaxHealth() / 2.0f));
            int currentHealthBars = Mth.ceil((float)(this.living.getHealth() / 2.0f));
            int emptyContainers = maxHealthBars - currentHealthBars;
            int availableSpace = Math.max(0, Math.min(emptyContainers, maxRottenHearts - data.getRottenHearts()));
            int amountToAdd = Math.max(1, Math.min((int)amount, availableSpace));
            data.addRottenHearts(amountToAdd, maxRottenHearts);
            RottenHeartManager.save(this.living);
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            MobEffectInstance rotgut = attackerLiving.getEffect(DDEffects.ROTGUT);
            RottenHeartData data = RottenHeartManager.get(attackerLiving);
            int rotten = data.getRottenHearts();
            if (rotgut != null && rotten > 0) {
                int healAmount = Math.max(1, Math.min((int)amount, rotten));
                attackerLiving.heal((float)healAmount);
                data.removeRottenHearts(healAmount);
                RottenHeartManager.save(attackerLiving);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onEffectRemoved"})
    private void dungeonsdelight$onEffectRemoved(MobEffectInstance effectInstance, CallbackInfo ci) {
        if (effectInstance.is(DDEffects.ROTGUT)) {
            DDUtil.clearRottenHearts(this.living);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"die"})
    private void dungeonsdelight$die(DamageSource damageSource, CallbackInfo ci) {
        DDUtil.clearRottenHearts(this.living);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setPose(Lnet/minecraft/world/entity/Pose;)V", shift=At.Shift.AFTER)}, method={"die"})
    private void dungeonsdelight$voracityDiscardAttempt(DamageSource damageSource, CallbackInfo ci) {
        LivingEntity killer2;
        LivingEntity self = (LivingEntity)this;
        Entity killer = damageSource.getEntity();
        if (killer instanceof LivingEntity && (killer2 = (LivingEntity)killer).hasEffect(DDEffects.VORACITY) && !self.isRemoved() && !self.getType().is(DDTags.EntityT.VORACITY_DEATH_FX_BLACKLIST)) {
            self.level().broadcastEntityEvent((Entity)self, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"hurt"}, argsOnly=true)
    public float dungeonsdelight$pouncingHurt(float amount, DamageSource source) {
        if (this.living.hasEffect(DDEffects.POUNCING) && source.is(DamageTypeTags.IS_FALL)) {
            int amplifier = this.living.getEffect(DDEffects.POUNCING).getAmplifier();
            float reduced = amount * (0.8f + 0.05f * (float)amplifier);
            if (reduced < 1.0f) {
                return 0.0f;
            }
            return reduced;
        }
        return amount;
    }

    @Inject(at={@At(value="HEAD")}, method={"createWitherRose"})
    private void dungeonsdelight$createWitherRose(LivingEntity attacker, CallbackInfo ci) {
        if (attacker != null && attacker.hasEffect(DDEffects.VORACITY)) {
            attacker.addEffect(new MobEffectInstance(DDEffects.RAVENOUS_RUSH, 100, 0));
            DDUtil.spreadParticles((ParticleOptions)DDParticles.DECISIVE_CRITICAL.get(), (Entity)this.living, random);
        }
    }

    private int getVoracityRefillAmount(LivingEntity living, float amount) {
        if (amount / 2.0f < 1.0f) {
            return 1;
        }
        if ((float)(living.getEffect(DDEffects.VORACITY).getAmplifier() + 4) > amount) {
            return (int)(amount / 2.0f);
        }
        return living.getEffect(DDEffects.VORACITY).getAmplifier() + 4;
    }

    @Inject(at={@At(value="HEAD")}, method={"isDamageSourceBlocked"}, cancellable=true)
    private void dungeonsdelight$isDamageSourceBlocked(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
    }

    @Inject(at={@At(value="HEAD")}, method={"canDisableShield"}, cancellable=true)
    private void dungeonsdelight$canDisableShield(CallbackInfoReturnable<Boolean> cir) {
        if (this.getMainHandItem().getItem() instanceof CleaverItem) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onClimbable"}, cancellable=true)
    private void dungeonsdelight$onClimbable(CallbackInfoReturnable<Boolean> cir) {
        BlockPos blockpos = this.living.blockPosition();
        if (this.living.hasEffect(DDEffects.POUNCING) && this.living.horizontalCollision && !this.living.isCrouching()) {
            this.lastClimbablePos = Optional.of(blockpos);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void dungeonsdelight$tick(CallbackInfo ci) {
        if (this.living.hasEffect(DDEffects.POUNCING) && this.living.horizontalCollision && this.living.isCrouching()) {
            Vec3 movement = this.living.getDeltaMovement();
            if (movement.y < -0.37) {
                double deltaMovement = -0.29 / movement.y;
                this.living.setDeltaMovement(new Vec3(movement.x * deltaMovement, -0.29, movement.z * deltaMovement));
            } else {
                this.living.setDeltaMovement(new Vec3(movement.x, -0.29, movement.z));
            }
            for (int i = 0; i < 5; ++i) {
                this.living.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.living.getBlockStateOn()), this.living.getX(), this.living.getY(), this.living.getZ(), 0.0, 0.0, 0.0);
            }
            this.living.resetFallDistance();
        }
    }
}

