/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.registry;

import java.util.function.Supplier;
import net.azurune.runiclib.common.publicized.PublicStairBlock;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.yirmiri.dungeonsdelight.common.block.DungeonStoveBlock;
import net.yirmiri.dungeonsdelight.common.block.EmbeddedEggsBlock;
import net.yirmiri.dungeonsdelight.common.block.EquipableRotgourdBlock;
import net.yirmiri.dungeonsdelight.common.block.GunkBlock;
import net.yirmiri.dungeonsdelight.common.block.ItemGrateBlock;
import net.yirmiri.dungeonsdelight.common.block.LivingCampfireBlock;
import net.yirmiri.dungeonsdelight.common.block.LivingCandleBlock;
import net.yirmiri.dungeonsdelight.common.block.LivingFireBlock;
import net.yirmiri.dungeonsdelight.common.block.LivingJackOLanternBlock;
import net.yirmiri.dungeonsdelight.common.block.LivingLanternBlock;
import net.yirmiri.dungeonsdelight.common.block.LivingTorchBlock;
import net.yirmiri.dungeonsdelight.common.block.RotbulbCropBlock;
import net.yirmiri.dungeonsdelight.common.block.RotbulbPlantBlock;
import net.yirmiri.dungeonsdelight.common.block.RotgourdBlock;
import net.yirmiri.dungeonsdelight.common.block.RottenCropBlock;
import net.yirmiri.dungeonsdelight.common.block.RottenPotatoCropBlock;
import net.yirmiri.dungeonsdelight.common.block.RottenTomatoesBlock;
import net.yirmiri.dungeonsdelight.common.block.WallLivingTorchBlock;
import net.yirmiri.dungeonsdelight.common.block.WormouthBlock;
import net.yirmiri.dungeonsdelight.common.block.WormrootTendrilsBlock;
import net.yirmiri.dungeonsdelight.common.block.WormrootsStalkBlock;
import net.yirmiri.dungeonsdelight.common.block.WormwoodButtonBlock;
import net.yirmiri.dungeonsdelight.common.block.food.CandleMonsterCakeBlock;
import net.yirmiri.dungeonsdelight.common.block.food.EXPPieBlock;
import net.yirmiri.dungeonsdelight.common.block.food.GuardianAngelBlock;
import net.yirmiri.dungeonsdelight.common.block.food.MonsterCakeBlock;
import net.yirmiri.dungeonsdelight.common.block.food.MonsterMousseBlock;
import net.yirmiri.dungeonsdelight.common.block.food.OssobucoBlock;
import net.yirmiri.dungeonsdelight.common.block.food.PolterghastPizzaBlock;
import net.yirmiri.dungeonsdelight.common.block.food.SilverfishAndChipsBlock;
import net.yirmiri.dungeonsdelight.common.block.food.SpiderDonutBlock;
import net.yirmiri.dungeonsdelight.common.block.monster_pot.MonsterPotBlock;
import net.yirmiri.dungeonsdelight.common.util.DDProperties;
import net.yirmiri.dungeonsdelight.core.init.DDBlockSetTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class DDBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"dungeonsdelight");
    public static final Supplier<Block> ROTBULB_CRATE = DDBlocks.registerBlockWOItem("rotbulb_crate", () -> new Block(DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> POISONOUS_POTATO_CRATE = DDBlocks.registerBlock("poisonous_potato_crate", () -> new Block(DDProperties.BlockP.CRATE));
    public static final Supplier<Block> ROTTEN_TOMATO_CRATE = DDBlocks.registerBlock("rotten_tomato_crate", () -> new Block(DDProperties.BlockP.CRATE));
    public static final Supplier<Block> SCULK_MAYO_BLOCK = DDBlocks.registerBlock("sculk_mayo_block", () -> new Block(DDProperties.BlockP.SCULK_MAYO));
    public static final Supplier<Block> GUNK = DDBlocks.registerBlockWOItem("gunk", () -> new GunkBlock(DDProperties.BlockP.GUNK));
    public static final Supplier<Block> ROTTEN_SPAWNER = DDBlocks.registerBlockWOItem("rotten_spawner", () -> new Block(DDProperties.BlockP.ROTTEN_SPAWNER));
    public static final Supplier<Block> STAINED_SCRAP_BLOCK = DDBlocks.registerBlockWOItem("stained_scrap_block", () -> new Block(DDProperties.BlockP.STAINED));
    public static final Supplier<Block> CUT_STAINED_SCRAP = DDBlocks.registerBlockWOItem("cut_stained_scrap", () -> new Block(DDProperties.BlockP.STAINED));
    public static final Supplier<Block> CUT_STAINED_SCRAP_STAIRS = DDBlocks.registerBlockWOItem("cut_stained_scrap_stairs", () -> new PublicStairBlock(CUT_STAINED_SCRAP.get().defaultBlockState(), DDProperties.BlockP.STAINED));
    public static final Supplier<Block> CUT_STAINED_SCRAP_SLAB = DDBlocks.registerBlockWOItem("cut_stained_scrap_slab", () -> new SlabBlock(DDProperties.BlockP.STAINED));
    public static final Supplier<Block> STAINED_SCRAP_BARS = DDBlocks.registerBlockWOItem("stained_scrap_bars", () -> new IronBarsBlock(DDProperties.BlockP.STAINED_SCRAP_BARS));
    public static final Supplier<Block> CHISELED_STAINED_SCRAP = DDBlocks.registerBlockWOItem("chiseled_stained_scrap", () -> new Block(DDProperties.BlockP.STAINED));
    public static final Supplier<Block> STAINED_SCRAP_PILLAR = DDBlocks.registerBlockWOItem("stained_scrap_pillar", () -> new RotatedPillarBlock(DDProperties.BlockP.STAINED));
    public static final Supplier<Block> STAINED_SCRAP_DOOR = DDBlocks.registerBlockWOItem("stained_scrap_door", () -> new DoorBlock(DDBlockSetTypes.STAINED_BLOCKSET, DDProperties.BlockP.STAINED_SCRAP_DOOR));
    public static final Supplier<Block> STAINED_SCRAP_TRAPDOOR = DDBlocks.registerBlockWOItem("stained_scrap_trapdoor", () -> new TrapDoorBlock(DDBlockSetTypes.STAINED_BLOCKSET, DDProperties.BlockP.STAINED_SCRAP_TRAPDOOR));
    public static final Supplier<Block> STAINED_SCRAP_GRATE = DDBlocks.registerBlockWOItem("stained_scrap_grate", () -> new ItemGrateBlock(DDProperties.BlockP.STAINED_GRATE));
    public static final Supplier<Block> LIVING_FIRE = DDBlocks.registerBlockWOItem("living_fire", () -> new LivingFireBlock(DDProperties.BlockP.LIVING_FIRE));
    public static final Supplier<Block> LIVING_CANDLE = DDBlocks.registerBlockWOItem("living_candle", () -> new LivingCandleBlock(DDProperties.BlockP.LIVING_CANDLE));
    public static final Supplier<Block> LIVING_CAMPFIRE = DDBlocks.registerBlockWOItem("living_campfire", () -> new LivingCampfireBlock(DDProperties.BlockP.LIVING_CAMPFIRE));
    public static final Supplier<Block> LIVING_LANTERN = DDBlocks.registerBlockWOItem("living_lantern", () -> new LivingLanternBlock(DDProperties.BlockP.LIVING_LANTERN));
    public static final Supplier<Block> LIVING_TORCH = DDBlocks.registerBlockWOItem("living_torch", () -> new LivingTorchBlock(DDProperties.BlockP.LIVING_TORCH));
    public static final Supplier<Block> WALL_LIVING_TORCH = DDBlocks.registerBlockWOItem("wall_living_torch", () -> new WallLivingTorchBlock(DDProperties.BlockP.LIVING_TORCH));
    public static final Supplier<Block> STAINED_LANTERN = DDBlocks.registerBlockWOItem("stained_lantern", () -> new Block(DDProperties.BlockP.LIVING_LAMP));
    public static final Supplier<Block> LIVING_JACK_O_LANTERN = DDBlocks.registerBlockWOItem("living_jack_o_lantern", () -> new LivingJackOLanternBlock(DDProperties.BlockP.LIVING_JACKO));
    public static final Supplier<Block> ROTBULB_CROP = DDBlocks.registerBlockWOItem("rotbulb_crop", () -> new RotbulbCropBlock(DDProperties.BlockP.ROTBULB));
    public static final Supplier<Block> ROTBULB_PLANT = DDBlocks.registerBlockWOItem("rotbulb_plant", () -> new RotbulbPlantBlock(DDProperties.BlockP.ROTBULB));
    public static final Supplier<Block> ROTTEN_CROP = DDBlocks.registerBlockWOItem("rotten_crop", () -> new RottenCropBlock(DDProperties.BlockP.ROTTEN_CROP));
    public static final Supplier<Block> ROTTEN_POTATOES = DDBlocks.registerBlockWOItem("rotten_potatoes", () -> new RottenPotatoCropBlock(DDProperties.BlockP.ROTTEN_CROP));
    public static final Supplier<Block> ROTTEN_TOMATOES = DDBlocks.registerBlockWOItem("rotten_tomatoes", () -> new RottenTomatoesBlock(DDProperties.BlockP.ROTTEN_CROP));
    public static final Supplier<Block> ROTGOURD = DDBlocks.registerBlockWOItem("rotgourd", () -> new RotgourdBlock(DDProperties.BlockP.PUMPKIN));
    public static final Supplier<Block> CARVED_ROTGOURD = DDBlocks.registerBlockWOItem("carved_rotgourd", () -> new EquipableRotgourdBlock(DDProperties.BlockP.PUMPKIN));
    public static final Supplier<Block> DUNGEON_STOVE = DDBlocks.registerBlockWOItem("dungeon_stove", () -> new DungeonStoveBlock(DDProperties.BlockP.DUNGEON_STOVE));
    public static final Supplier<Block> MONSTER_POT = DDBlocks.registerBlockWOItem("monster_pot", () -> new MonsterPotBlock(DDProperties.BlockP.MONSTER_POT));
    public static final Supplier<Block> EMBEDDED_EGGS = DDBlocks.registerBlock("embedded_eggs", () -> new EmbeddedEggsBlock(DDProperties.BlockP.SCULK_EGGS));
    public static final Supplier<Block> HEAP_OF_ANCIENT_EGGS = DDBlocks.registerBlock("heap_of_ancient_eggs", () -> new Block(DDProperties.BlockP.SCULK_EGGS));
    public static final Supplier<Block> SPIDER_PIE = DDBlocks.registerBlockWOItem("spider_pie", () -> new PieBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE), DDItems.SPIDER_PIE_SLICE));
    public static final Supplier<Block> SCULK_TART = DDBlocks.registerBlock("sculk_tart", () -> new EXPPieBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).sound(SoundType.SCULK), 15, DDItems.SCULK_TART_SLICE));
    public static final Supplier<Block> MONSTER_CAKE = DDBlocks.registerBlockWOItem("monster_cake", () -> new MonsterCakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE)));
    public static final Supplier<Block> CANDLE_MONSTER_CAKE = DDBlocks.registerBlockWOItem("candle_monster_cake", () -> new CandleMonsterCakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CANDLE_CAKE)));
    public static final Supplier<Block> SPIDER_DONUT = DDBlocks.registerBlockWOItem("spider_donut", () -> new SpiderDonutBlock(DDProperties.BlockP.SPIDER_DONUT));
    public static final Supplier<Block> POLTERGHAST_PIZZA = DDBlocks.registerBlockWOItem("polterghast_pizza", () -> new PolterghastPizzaBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).sound(SoundType.HONEY_BLOCK).noOcclusion(), 10, DDItems.POLTERGHAST_PIZZA_SLICE));
    public static final Supplier<Block> MONSTER_MOUSSE_BLOCK = DDBlocks.registerBlockWOItem("monster_mousse_block", () -> new MonsterMousseBlock(DDProperties.BlockP.MONSTER_MOUSSE_BLOCK, DDItems.MONSTER_MOUSSE, true));
    public static final Supplier<Block> OSSOBUCO_BLOCK = DDBlocks.registerBlockWOItem("ossobuco_block", () -> new OssobucoBlock(DDProperties.BlockP.OSSOBUCO_BLOCK, DDItems.OSSOBUCO, true));
    public static final Supplier<Block> GUARDIAN_ANGEL_BLOCK = DDBlocks.registerBlockWOItem("guardian_angel_block", () -> new GuardianAngelBlock(DDProperties.BlockP.GUARDIAN_ANGEL_BLOCK, DDItems.GUARDIAN_ANGEL, true));
    public static final Supplier<Block> SILVERFISH_AND_CHIPS_BLOCK = DDBlocks.registerBlockWOItem("silverfish_and_chips_block", () -> new SilverfishAndChipsBlock(DDProperties.BlockP.SILVERFISH_AND_CHIPS_BLOCK, DDItems.SILVERFISH_AND_CHIPS, true));
    public static final Supplier<Block> WORMROOT_TENDRILS = DDBlocks.registerBlock("wormroot_tendrils", () -> new WormrootTendrilsBlock(DDProperties.BlockP.WORMROOT_TENDRILS));
    public static final Supplier<Block> WORMROOT_STALK = DDBlocks.registerBlock("wormroot_stalk", () -> new WormrootsStalkBlock(DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> WORMOUTH = DDBlocks.registerBlock("wormouth", () -> new WormouthBlock(DDProperties.BlockP.WORMOUTH));
    public static final Supplier<Block> WORMROOTS_BLOCK = DDBlocks.registerBlock("wormroots_block", () -> new Block(DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> WORMWOOD_PLANKS = DDBlocks.registerBlock("wormwood_planks", () -> new Block(DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> WORMWOOD_STAIRS = DDBlocks.registerBlock("wormwood_stairs", () -> new PublicStairBlock(WORMWOOD_PLANKS.get().defaultBlockState(), DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> WORMWOOD_SLAB = DDBlocks.registerBlock("wormwood_slab", () -> new SlabBlock(DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> WORMWOOD_MOSAIC = DDBlocks.registerBlock("wormwood_mosaic", () -> new Block(DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> WORMWOOD_MOSAIC_STAIRS = DDBlocks.registerBlock("wormwood_mosaic_stairs", () -> new PublicStairBlock(WORMWOOD_MOSAIC.get().defaultBlockState(), DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> WORMWOOD_MOSAIC_SLAB = DDBlocks.registerBlock("wormwood_mosaic_slab", () -> new SlabBlock(DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> WORMWOOD_FENCE = DDBlocks.registerBlock("wormwood_fence", () -> new FenceBlock(DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> WORMWOOD_FENCE_GATE = DDBlocks.registerBlock("wormwood_fence_gate", () -> new FenceGateBlock(DDBlockSetTypes.WORMWOOD, DDProperties.BlockP.WORMWOOD));
    public static final Supplier<Block> WORMWOOD_DOOR = DDBlocks.registerBlock("wormwood_door", () -> new DoorBlock(DDBlockSetTypes.WORMWOOD_BLOCKSET, DDProperties.BlockP.WORMWOOD_DOOR));
    public static final Supplier<Block> WORMWOOD_TRAPDOOR = DDBlocks.registerBlock("wormwood_trapdoor", () -> new TrapDoorBlock(DDBlockSetTypes.WORMWOOD_BLOCKSET, DDProperties.BlockP.WORMWOOD_TRAPDOOR));
    public static final Supplier<Block> WORMWOOD_BUTTON = DDBlocks.registerBlock("wormwood_button", () -> new WormwoodButtonBlock(DDBlockSetTypes.WORMWOOD_BLOCKSET, 20, DDProperties.BlockP.WORMWOOD_BUTTON));
    public static final Supplier<Block> WORMWOOD_PRESSURE_PLATE = DDBlocks.registerBlock("wormwood_pressure_plate", () -> new PressurePlateBlock(DDBlockSetTypes.WORMWOOD_BLOCKSET, DDProperties.BlockP.WORMWOOD_PRESSURE_PLATE));
    public static final Supplier<Block> WORMWOOD_CABINET = DDBlocks.registerBlock("wormwood_cabinet", () -> new CabinetBlock(DDProperties.BlockP.WORMWOOD_CABINET));

    private static <T extends Block> Supplier<T> registerBlock(String id, Supplier<T> block) {
        DeferredHolder blockRegister = BLOCKS.register(id, block);
        DDBlocks.registerBlockItem(id, blockRegister);
        return blockRegister;
    }

    private static <T extends Block> Supplier<T> registerBlockWOItem(String id, Supplier<T> block) {
        return BLOCKS.register(id, block);
    }

    private static <T extends Block> void registerBlockItem(String id, Supplier<T> block) {
        DDItems.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> Supplier<T> registerFeastBlock(String id, Supplier<T> block) {
        DeferredHolder blockRegister = BLOCKS.register(id, block);
        DDBlocks.registerFeastBlockItem(id, blockRegister);
        return blockRegister;
    }

    private static <T extends Block> void registerFeastBlockItem(String id, Supplier<T> block) {
        DDItems.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties().stacksTo(1)));
    }
}

