/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.datagen;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import vectorwing.farmersdelight.common.registry.ModItems;

public class DDBlockLootGen
extends BlockLootSubProvider {
    HolderLookup.RegistryLookup<Enchantment> registrylookup;
    private final Set<Block> generatedLootTables;

    public DDBlockLootGen(HolderLookup.Provider holder) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), holder);
        this.registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.generatedLootTables = new HashSet<Block>();
    }

    protected void generate() {
        this.dropSelf(DDBlocks.DUNGEON_STOVE.get());
        this.dropSelf(DDBlocks.WORMWOOD_PLANKS.get());
        this.dropSelf(DDBlocks.WORMWOOD_STAIRS.get());
        this.createSlabItemTable(DDBlocks.WORMWOOD_SLAB.get());
        this.add(DDBlocks.WORMWOOD_SLAB.get(), this.createSlabItemTable(DDBlocks.WORMWOOD_SLAB.get()));
        this.dropSelf(DDBlocks.WORMWOOD_MOSAIC.get());
        this.dropSelf(DDBlocks.WORMWOOD_MOSAIC_STAIRS.get());
        this.dropSelf(DDBlocks.WORMWOOD_MOSAIC_SLAB.get());
        this.createDoorTable(DDBlocks.WORMWOOD_DOOR.get());
        this.add(DDBlocks.WORMWOOD_DOOR.get(), block -> this.createDoorTable(DDBlocks.WORMWOOD_DOOR.get()));
        this.dropSelf(DDBlocks.WORMWOOD_TRAPDOOR.get());
        this.dropSelf(DDBlocks.WORMWOOD_BUTTON.get());
        this.dropSelf(DDBlocks.WORMWOOD_PRESSURE_PLATE.get());
        this.dropSelf(DDBlocks.WORMWOOD_FENCE.get());
        this.dropSelf(DDBlocks.WORMWOOD_FENCE_GATE.get());
        this.dropNamedContainer(DDBlocks.WORMWOOD_CABINET.get());
        this.add(DDBlocks.WORMROOT_TENDRILS.get(), block -> this.createMultifaceBlockDrops(DDBlocks.WORMROOT_TENDRILS));
        this.dropSelf(DDBlocks.EMBEDDED_EGGS.get());
        this.add(DDBlocks.HEAP_OF_ANCIENT_EGGS.get(), this.createAncientEggsDrops(DDBlocks.HEAP_OF_ANCIENT_EGGS));
        this.dropSelf(DDBlocks.SCULK_MAYO_BLOCK.get());
        this.dropSelf(DDBlocks.WORMROOTS_BLOCK.get());
        this.dropSelf(DDBlocks.ROTBULB_CRATE.get());
        this.dropSelf(DDBlocks.STAINED_SCRAP_BLOCK.get());
        this.dropSelf(DDBlocks.CHISELED_STAINED_SCRAP.get());
        this.dropSelf(DDBlocks.CUT_STAINED_SCRAP.get());
        this.dropSelf(DDBlocks.CUT_STAINED_SCRAP_STAIRS.get());
        this.dropSelf(DDBlocks.CUT_STAINED_SCRAP_SLAB.get());
        this.dropSelf(DDBlocks.STAINED_SCRAP_BARS.get());
        this.add(DDBlocks.ROTTEN_CROP.get(), this.createRotCropDrops(DDBlocks.ROTTEN_CROP, DDItems.GUNK.get()));
        this.add(DDBlocks.ROTTEN_POTATOES.get(), this.createRotCropDrops(DDBlocks.ROTTEN_POTATOES, Items.POISONOUS_POTATO));
        this.add(DDBlocks.ROTTEN_TOMATOES.get(), this.createRotCropDrops(DDBlocks.ROTTEN_TOMATOES, (Item)ModItems.ROTTEN_TOMATO.get()));
        this.dropOther(DDBlocks.CANDLE_MONSTER_CAKE.get(), (ItemLike)DDBlocks.LIVING_CANDLE.get());
        this.dropSelf(DDBlocks.POISONOUS_POTATO_CRATE.get());
        this.dropSelf(DDBlocks.ROTTEN_TOMATO_CRATE.get());
        this.add(DDBlocks.GUNK.get(), block -> this.createMultifaceBlockDrops(DDBlocks.GUNK));
        this.add(DDBlocks.ROTTEN_SPAWNER.get(), this.createRottenSpawnerDrops(DDBlocks.ROTTEN_SPAWNER));
        this.dropSelf(DDBlocks.LIVING_TORCH.get());
        this.dropSelf(DDBlocks.WALL_LIVING_TORCH.get());
        this.dropSelf(DDBlocks.LIVING_LANTERN.get());
        this.add(DDBlocks.LIVING_CAMPFIRE.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)DDItems.STAINED_SCRAP.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))));
        this.dropSelf(DDBlocks.LIVING_CANDLE.get());
        this.dropSelf(DDBlocks.STAINED_SCRAP_GRATE.get());
        this.dropSelf(DDBlocks.STAINED_LANTERN.get());
        this.dropSelf(DDBlocks.STAINED_SCRAP_PILLAR.get());
        this.dropSelf(DDBlocks.STAINED_SCRAP_TRAPDOOR.get());
        this.add(DDBlocks.STAINED_SCRAP_DOOR.get(), this.createDoorTable(DDBlocks.STAINED_SCRAP_DOOR.get()));
        this.dropSelf(DDBlocks.ROTGOURD.get());
        this.dropSelf(DDBlocks.CARVED_ROTGOURD.get());
        this.dropSelf(DDBlocks.LIVING_JACK_O_LANTERN.get());
    }

    protected void add(Block block, LootTable.Builder builder) {
        this.generatedLootTables.add(block);
        this.map.put(block.getLootTable(), builder);
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.generatedLootTables;
    }

    protected void dropNamedContainer(Block block) {
        this.add(block, x$0 -> this.createNameableBlockEntityTable((Block)x$0));
    }

    protected LootTable.Builder createDoorTable(Block doorBlock) {
        return this.createSinglePropConditionTable(doorBlock, (Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    protected LootTable.Builder createMultifaceBlockDrops(Supplier<Block> block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block.get(), (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)block.get())).apply((Object[])Direction.values(), object -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f), (boolean)true).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)block.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MultifaceBlock.getFaceProperty((Direction)((Direction)object)), true))))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)-1.0f), (boolean)true)))));
    }

    protected LootTable.Builder createAncientEggsDrops(Supplier<Block> block) {
        return this.createSilkTouchDispatchTable(block.get(), (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block.get(), (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)DDItems.ANCIENT_EGG.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)5.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createRotCropDrops(Supplier<Block> block, Item item) {
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)block.get(), (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)this.registrylookup.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3)))));
    }

    protected LootTable.Builder createRottenSpawnerDrops(Supplier<Block> block) {
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)block.get(), (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)DDItems.GUNK.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)8.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registrylookup.getOrThrow(Enchantments.FORTUNE))))));
    }
}

