/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.integration.util;

import net.azurune.runiclib.core.register.RLMobEffects;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.yirmiri.dungeonsdelight.common.util.DDProperties;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class INProperties {
    public static FoodProperties createCupFoodProperties(FoodProperties foodProperties) {
        int foodLevel = foodProperties.nutrition();
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(Mth.floor((float)((float)foodLevel / 2.0f))).saturationModifier(INProperties.saturationModifier(foodLevel, foodProperties.saturation()));
        for (FoodProperties.PossibleEffect possibleEffect : foodProperties.effects()) {
            builder.effect(() -> {
                MobEffectInstance effectInstance = (MobEffectInstance)possibleEffect.effectSupplier().get();
                return new MobEffectInstance(effectInstance.getEffect(), effectInstance.getDuration() / 2, effectInstance.getAmplifier(), effectInstance.isAmbient(), effectInstance.isVisible(), effectInstance.showIcon());
            }, possibleEffect.probability());
        }
        builder.fast();
        if (foodProperties.canAlwaysEat()) {
            builder.alwaysEdible();
        }
        return builder.build();
    }

    public static float saturationModifier(int foodLevel, float saturation) {
        return saturation / (float)foodLevel / 2.0f;
    }

    public static class FoodP {
        public static final FoodProperties SCULK_DOGAPPLE = new FoodProperties.Builder().nutrition(5).saturationModifier(0.5f).alwaysEdible().build();
        public static final FoodProperties BUG_CHOPS = new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).build();
        public static final FoodProperties FRIED_BUG_CHOPS = new FoodProperties.Builder().nutrition(8).saturationModifier(0.8f).build();
        public static final FoodProperties TORCHBERRY_RAISINS = new FoodProperties.Builder().nutrition(1).saturationModifier(0.3f).fast().build();
        public static final FoodProperties WILDERNESS_LUNCHEON = new FoodProperties.Builder().nutrition(7).saturationModifier(0.6f).build();
        public static final FoodProperties MAZE_ROLL = new FoodProperties.Builder().nutrition(6).saturationModifier(0.6f).fast().build();
        public static final FoodProperties MEEF_WELLINGTON = new FoodProperties.Builder().nutrition(10).saturationModifier(0.7f).build();
        public static final FoodProperties MARBLED_MEAT = new FoodProperties.Builder().nutrition(3).saturationModifier(0.3f).build();
        public static final FoodProperties COOKED_MARBLED_MEAT = new FoodProperties.Builder().nutrition(8).saturationModifier(0.8f).build();
        public static final FoodProperties VOLAILLE = new FoodProperties.Builder().nutrition(6).saturationModifier(0.5f).build();
        public static final FoodProperties VENOMOUS_ONIGIRI = new FoodProperties.Builder().nutrition(7).saturationModifier(0.8f).fast().effect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 1), 1.0f).build();
        public static final FoodProperties AMBROSIA_RING = new FoodProperties.Builder().nutrition(10).saturationModifier(0.8f).effect(new MobEffectInstance(DDEffects.VORACITY, 3600, 0), 1.0f).effect(new MobEffectInstance(DDEffects.SWIFT_STEP, 1800, 0), 1.0f).build();
        public static final FoodProperties AMBER_E_OLIO = new FoodProperties.Builder().nutrition(8).saturationModifier(0.6f).effect(new MobEffectInstance(DDEffects.VORACITY, 4800, 0), 1.0f).build();
        public static final FoodProperties FLUFFY_FLOSS = new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).alwaysEdible().effect(new MobEffectInstance(DDEffects.SWIFT_STEP, 1200, 0), 1.0f).build();
        public static final FoodProperties LUTEFISK = new FoodProperties.Builder().nutrition(4).saturationModifier(0.4f).effect(new MobEffectInstance(RLMobEffects.WATER_WALKING, 1800, 0), 1.0f).effect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0), 1.0f).build();
        public static final FoodProperties TOWER_BOREITO = new FoodProperties.Builder().nutrition(12).saturationModifier(1.2f).effect(new MobEffectInstance(DDEffects.BURROW_GUT, 6000, 1), 1.0f).build();
        public static final FoodProperties AURORA_ICE_CREAM = new FoodProperties.Builder().nutrition(9).saturationModifier(0.5f).effect(new MobEffectInstance(ModEffects.COMFORT, 2400, 0), 1.0f).effect(new MobEffectInstance(MobEffects.NIGHT_VISION, 2400, 0), 1.0f).effect(new MobEffectInstance(RLMobEffects.PERCEPTION, 600, 0), 1.0f).build();
        public static final FoodProperties BLAZING_BLOOD_SAUSAGE = new FoodProperties.Builder().nutrition(14).saturationModifier(0.9f).effect(new MobEffectInstance(DDEffects.BURROW_GUT, 4800, 0), 1.0f).effect(new MobEffectInstance(RLMobEffects.PYROMANIAC, 2400, 0), 1.0f).build();
        public static final FoodProperties ARCANE_CHILI = new FoodProperties.Builder().nutrition(7).saturationModifier(0.7f).alwaysEdible().effect(new MobEffectInstance(DDEffects.TENACITY, 12000, 0), 1.0f).effect(new MobEffectInstance(RLMobEffects.PYROMANIAC, 2400, 0), 1.0f).build();
        public static final FoodProperties HYDRA_FRICASSEE = new FoodProperties.Builder().nutrition(10).saturationModifier(1.0f).effect(new MobEffectInstance(DDEffects.VORACITY, 7200, 1), 1.0f).effect(new MobEffectInstance(RLMobEffects.PYROMANIAC, 2400, 0), 1.0f).build();
        public static final FoodProperties SWEETBREAD = new FoodProperties.Builder().nutrition(6).saturationModifier(0.8f).fast().effect(new MobEffectInstance(DDEffects.BURROW_GUT, 1200, 0), 1.0f).build();
        public static final FoodProperties SCALY_FIDDLEHEAD_RISOTTO = new FoodProperties.Builder().nutrition(8).saturationModifier(0.8f).effect(new MobEffectInstance(DDEffects.VORACITY, 9600, 1), 1.0f).build();
        public static final FoodProperties MAZE_SMORE = new FoodProperties.Builder().nutrition(5).saturationModifier(0.5f).fast().effect(new MobEffectInstance(DDEffects.SWIFT_STEP, 1200, 0), 1.0f).build();
        public static final FoodProperties SKYBERRY_BREW = new FoodProperties.Builder().alwaysEdible().effect(new MobEffectInstance(MobEffects.HEALTH_BOOST, 2400, 1), 1.0f).build();
        public static final FoodProperties LIVEROOT_BEER = new FoodProperties.Builder().nutrition(2).saturationModifier(0.4f).alwaysEdible().effect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 0), 1.0f).build();
        public static final FoodProperties TROLLBER_CHUTNEY = new FoodProperties.Builder().nutrition(5).saturationModifier(0.5f).alwaysEdible().effect(new MobEffectInstance(RLMobEffects.PERCEPTION, 300, 0), 1.0f).build();
    }

    public static class ItemP {
        public static final Item.Properties SCULK_DOGAPPLE = new Item.Properties().food(FoodP.SCULK_DOGAPPLE);
        public static final Item.Properties BUG_CHOPS = new Item.Properties().food(FoodP.BUG_CHOPS);
        public static final Item.Properties FRIED_BUG_CHOPS = new Item.Properties().food(FoodP.FRIED_BUG_CHOPS);
        public static final Item.Properties TORCHBERRY_RAISINS = new Item.Properties().food(FoodP.TORCHBERRY_RAISINS);
        public static final Item.Properties WILDERNESS_LUNCHEON = new Item.Properties().food(FoodP.WILDERNESS_LUNCHEON);
        public static final Item.Properties MAZE_ROLL = new Item.Properties().food(FoodP.MAZE_ROLL);
        public static final Item.Properties MEEF_WELLINGTON = new Item.Properties().food(FoodP.MEEF_WELLINGTON);
        public static final Item.Properties MARBLED_MEAT = new Item.Properties().food(FoodP.MARBLED_MEAT);
        public static final Item.Properties COOKED_MARBLED_MEAT = new Item.Properties().food(FoodP.COOKED_MARBLED_MEAT);
        public static final Item.Properties VOLAILLE = new Item.Properties().food(FoodP.VOLAILLE);
        public static final Item.Properties SWEETBREAD = new Item.Properties().food(FoodP.SWEETBREAD).rarity(DDProperties.MONSTER);
        public static final Item.Properties LUTEFISK = new Item.Properties().food(FoodP.LUTEFISK);
        public static final Item.Properties MAZE_SMORE = new Item.Properties().food(FoodP.MAZE_SMORE).rarity(DDProperties.MONSTER);
        public static final Item.Properties ARCANE_CHILI = new Item.Properties().food(FoodP.ARCANE_CHILI).durability(16).craftRemainder(Items.BUCKET).rarity(DDProperties.MONSTER);
        public static final Item.Properties FLUFFY_FLOSS = new Item.Properties().food(FoodP.FLUFFY_FLOSS).rarity(DDProperties.MONSTER).durability(8);
        public static final Item.Properties TOWER_BOREITO = new Item.Properties().food(FoodP.TOWER_BOREITO).stacksTo(16).rarity(DDProperties.MONSTER);
        public static final Item.Properties AURORA_ICE_CREAM = new Item.Properties().food(FoodP.AURORA_ICE_CREAM).stacksTo(16).craftRemainder(Items.BOWL);
        public static final Item.Properties BLAZING_BLOOD_SAUSAGE = new Item.Properties().food(FoodP.BLAZING_BLOOD_SAUSAGE).stacksTo(16).rarity(DDProperties.MONSTER);
        public static final Item.Properties HYDRA_FRICASSEE = new Item.Properties().food(FoodP.HYDRA_FRICASSEE).craftRemainder(Items.BOWL).stacksTo(16).rarity(DDProperties.MONSTER);
        public static final Item.Properties SCALY_FIDDLEHEAD_RISOTTO = new Item.Properties().food(FoodP.SCALY_FIDDLEHEAD_RISOTTO).craftRemainder(Items.BOWL).stacksTo(16).rarity(DDProperties.MONSTER);
        public static final Item.Properties AMBER_E_OLIO = new Item.Properties().food(FoodP.AMBER_E_OLIO).rarity(DDProperties.MONSTER).craftRemainder(Items.BOWL).stacksTo(16);
        public static final Item.Properties AMBROSIA_RING = new Item.Properties().food(FoodP.AMBROSIA_RING).rarity(DDProperties.MONSTER).craftRemainder(Items.BOWL).stacksTo(16);
        public static final Item.Properties VENOMOUS_ONIGIRI = new Item.Properties().food(FoodP.VENOMOUS_ONIGIRI);
        public static final Item.Properties LIVEROOT_BEER = new Item.Properties().food(FoodP.LIVEROOT_BEER).stacksTo(16).craftRemainder(Items.GLASS_BOTTLE);
        public static final Item.Properties TROLLBER_CHUTNEY = new Item.Properties().food(FoodP.TROLLBER_CHUTNEY).stacksTo(16).craftRemainder(Items.GLASS_BOTTLE);
        public static final Item.Properties SKYBERRY_BREW = new Item.Properties().food(FoodP.SKYBERRY_BREW).stacksTo(16).craftRemainder(Items.GLASS_BOTTLE).rarity(DDProperties.MONSTER);
        public static final Item.Properties SALT_SOAKED_STEW_CUP = new Item.Properties().food(INProperties.createCupFoodProperties(DDProperties.FoodP.SALT_SOAKED_STEW)).rarity(DDProperties.MONSTER).stacksTo(16);
        public static final Item.Properties SPIDER_SALMAGUNDI_CUP = new Item.Properties().food(INProperties.createCupFoodProperties(DDProperties.FoodP.SPIDER_SALMAGUNDI)).rarity(DDProperties.MONSTER).stacksTo(16);
        public static final Item.Properties POI_CUP = new Item.Properties().food(INProperties.createCupFoodProperties(DDProperties.FoodP.POI)).rarity(DDProperties.MONSTER).stacksTo(16);
        public static final Item.Properties RUBABOO_CUP = new Item.Properties().food(INProperties.createCupFoodProperties(DDProperties.FoodP.RUBABOO)).rarity(DDProperties.MONSTER).durability(8).setNoRepair();
    }

    public static class BlockP {
    }
}

