/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.events;

import com.ultramega.playershells.gui.ShellSelectionOverlay;
import com.ultramega.playershells.registry.ModBlockEntityTypes;
import com.ultramega.playershells.storage.ShellSavedData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;

@EventBusSubscriber
public final class CommonEvents {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, ModBlockEntityTypes.SHELL_FORGE.get(), (blockEntity, side) -> blockEntity.energyStorage);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, ModBlockEntityTypes.CENTRIFUGE.get(), (blockEntity, side) -> blockEntity.energyStorage);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.CENTRIFUGE.get(), (blockEntity, side) -> blockEntity.inventoryHandler);
    }

    @SubscribeEvent
    public static void onPlayerJoinLevel(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ShellSavedData.getShellData(serverLevel).syncToClient();
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaveLevel(EntityLeaveLevelEvent event) {
        if (event.getLevel() instanceof ClientLevel && event.getEntity() instanceof Player && ShellSelectionOverlay.INSTANCE.isOpened()) {
            ShellSelectionOverlay.INSTANCE.close(false);
        }
    }
}

