/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.mixin;

import com.mojang.authlib.GameProfile;
import com.ultramega.playershells.blocks.AbstractMultiblockBlock;
import com.ultramega.playershells.packet.c2s.TransferPlayerPacket;
import com.ultramega.playershells.packet.s2c.AfterDeathPacket;
import com.ultramega.playershells.packet.s2c.FinishedSyncPacket;
import com.ultramega.playershells.storage.ShellSavedData;
import com.ultramega.playershells.storage.ShellState;
import com.ultramega.playershells.utils.MathUtils;
import com.ultramega.playershells.utils.PositionReference;
import com.ultramega.playershells.utils.ShellPlayer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayer
extends Player
implements ShellPlayer {
    @Shadow
    @Final
    public MinecraftServer server;
    @Shadow
    public ServerGamePacketListenerImpl connection;
    @Shadow
    @Final
    public ServerPlayerGameMode gameMode;

    public MixinServerPlayer(Level level, BlockPos pos, float rotY, GameProfile gameProfile) {
        super(level, pos, rotY, gameProfile);
    }

    @Override
    public void playershells$applyData(CompoundTag tag, PositionReference posReference) {
        if (this.getServer() == null) {
            return;
        }
        ServerLevel targetLevel = MathUtils.findTargetLevel(this.getServer(), posReference);
        if (targetLevel == null) {
            return;
        }
        BlockPos pos = posReference.pos().immutable();
        LevelChunk chunk = targetLevel.getChunk(pos.getX() >> 4, pos.getZ() >> 4);
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.0625;
        double z = (double)pos.getZ() + 0.5;
        BlockState state = chunk.getBlockState(pos);
        float yaw = state.hasProperty((Property)AbstractMultiblockBlock.FACING) ? ((Direction)state.getValue((Property)AbstractMultiblockBlock.FACING)).toYRot() : 0.0f;
        this.teleportTo(targetLevel, x, y, z, yaw, 0.0f);
        this.removeAllEffects();
        this.load(tag);
        this.loadGameTypes(tag);
        ServerPlayer serverPlayer = (ServerPlayer)this;
        PlayerList playerList = this.server.getPlayerList();
        this.onUpdateAbilities();
        playerList.broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE, serverPlayer));
        this.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.CHANGE_GAME_MODE, (float)this.gameMode.getGameModeForPlayer().getId()));
        this.getStats().markAllDirty();
        this.updateEffectVisibility();
        playerList.sendActivePlayerEffects(serverPlayer);
        playerList.sendAllPlayerInfo(serverPlayer);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new FinishedSyncPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    private void die(DamageSource cause, CallbackInfo ci) {
        ShellState shellState = ShellSavedData.getShellData(this.serverLevel()).getNearestActive(this.getUUID(), this.level().dimension().location(), this.blockPosition());
        if (shellState == null) {
            return;
        }
        this.playershells$sendDeathMessageInChat();
        this.removeEntitiesOnShoulder();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            this.tellNeutralMobsThatIDied();
        }
        if (!this.isSpectator()) {
            this.dropAllDeathLoot(this.serverLevel(), cause);
        }
        this.dead = false;
        this.setHealth(0.01f);
        this.clearFire();
        this.setTicksFrozen(0);
        this.setSharedFlagOnFire(false);
        if (this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            this.playershells$dropItemsAndExp(shellState.shellForgePos());
        }
        ServerPlayer serverPlayer = (ServerPlayer)this;
        TransferPlayerPacket.transfer(this.server, (Player)serverPlayer, null, shellState.shellForgePos());
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new AfterDeathPacket(shellState.shellForgePos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ci.cancel();
    }

    @Override
    public CompoundTag playershells$getData() {
        CompoundTag tag = new CompoundTag();
        this.saveWithoutId(tag);
        this.storeGameTypes(tag);
        return tag;
    }

    @Unique
    private void playershells$sendDeathMessageInChat() {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES)) {
            Component deathMessage = this.getCombatTracker().getDeathMessage();
            MutableComponent transferredMessage = Component.translatable((String)("death.playershells.transferred_to_shell_" + this.random.nextInt(0, 4)));
            MutableComponent betterDeathMessage = Component.literal((String)(deathMessage.getString() + ". " + transferredMessage.getString()));
            this.connection.send((Packet)new ClientboundPlayerCombatKillPacket(this.getId(), (Component)betterDeathMessage), PacketSendListener.exceptionallySend(() -> this.lambda$playershells$sendDeathMessageInChat$1((Component)betterDeathMessage)));
            PlayerTeam team = this.getTeam();
            if (team != null && team.getDeathMessageVisibility() != Team.Visibility.ALWAYS) {
                if (team.getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                    this.server.getPlayerList().broadcastSystemToTeam((Player)this, (Component)betterDeathMessage);
                } else if (team.getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                    this.server.getPlayerList().broadcastSystemToAllExceptTeam((Player)this, (Component)betterDeathMessage);
                }
            } else {
                this.server.getPlayerList().broadcastSystemMessage((Component)betterDeathMessage, false);
            }
        } else {
            this.connection.send((Packet)new ClientboundPlayerCombatKillPacket(this.getId(), CommonComponents.EMPTY));
        }
    }

    @Unique
    private void playershells$dropItemsAndExp(PositionReference posReference) {
        ServerLevel targetLevel = MathUtils.findTargetLevel(this.server, posReference);
        if (targetLevel == null) {
            return;
        }
        BlockPos pos = posReference.pos();
        for (int i = 0; i < this.getInventory().getContainerSize(); ++i) {
            ItemStack stack = this.getInventory().getItem(i);
            if (stack.isEmpty()) continue;
            ItemEntity itementity = new ItemEntity(this.level(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
            targetLevel.addFreshEntity((Entity)itementity);
        }
        ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)pos.getCenter(), (int)this.totalExperience);
    }

    @Shadow
    public abstract void teleportTo(ServerLevel var1, double var2, double var4, double var6, float var8, float var9);

    @Shadow
    protected abstract void tellNeutralMobsThatIDied();

    @Shadow
    public abstract ServerLevel serverLevel();

    @Shadow
    public abstract ServerStatsCounter getStats();

    @Shadow
    public abstract void loadGameTypes(@Nullable CompoundTag var1);

    @Shadow
    public abstract void storeGameTypes(CompoundTag var1);

    private /* synthetic */ Packet lambda$playershells$sendDeathMessageInChat$1(Component betterDeathMessage) {
        MutableComponent component1 = Component.translatable((String)"death.attack.message_too_long", (Object[])new Object[]{Component.literal((String)betterDeathMessage.getString(256)).withStyle(ChatFormatting.YELLOW)});
        MutableComponent component2 = Component.translatable((String)"death.attack.even_more_magic", (Object[])new Object[]{this.getDisplayName()}).withStyle(arg_0 -> MixinServerPlayer.lambda$playershells$sendDeathMessageInChat$0((Component)component1, arg_0));
        return new ClientboundPlayerCombatKillPacket(this.getId(), (Component)component2);
    }

    private static /* synthetic */ Style lambda$playershells$sendDeathMessageInChat$0(Component component1, Style style) {
        return style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)component1));
    }
}

