/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.gui.layer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultramega.playershells.items.SyringeItem;
import com.ultramega.playershells.registry.ModItems;
import com.ultramega.playershells.utils.MathUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public class BloodLayer
implements LayeredDraw.Layer {
    private static final ResourceLocation UNDERWATER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"textures/gui/blood_overlay.png");
    private static final float PULSE_WIDTH = 0.02f;
    private static final float MAX_ALPHA = 0.4f;

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (!player.isHolding((Item)ModItems.EMPTY_SYRINGE.get())) {
            return;
        }
        float usePos = (float)(player.getMainHandItem().getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks()) / 100.0f;
        float alpha = BloodLayer.pulseAlpha(usePos);
        if (alpha > 0.01f) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
            graphics.blit(UNDERWATER_LOCATION, 0, 0, 0, 0.0f, 0.0f, graphics.guiWidth(), graphics.guiHeight(), graphics.guiWidth(), graphics.guiHeight());
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static float pulseAlpha(float usePos) {
        float alphaFactor = 0.0f;
        for (float point : SyringeItem.PULSE_POINTS) {
            float d = Math.abs(usePos - point);
            if (!(d < 0.02f)) continue;
            float t = 1.0f - d / 0.02f;
            float smooth = MathUtils.smoothstep01(t);
            alphaFactor = Math.max(alphaFactor, smooth);
        }
        return alphaFactor * 0.4f;
    }
}

