/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.blocks;

import com.ultramega.playershells.blockentities.CentrifugeBlockEntity;
import com.ultramega.playershells.registry.ModBlockEntityTypes;
import com.ultramega.playershells.utils.MathUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class CentrifugeBlock
extends Block
implements EntityBlock {
    public CentrifugeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CentrifugeBlockEntity) {
            CentrifugeBlockEntity blockEntity2 = (CentrifugeBlockEntity)blockEntity;
            if (!level.isClientSide()) {
                player.openMenu((MenuProvider)blockEntity2, pos);
            }
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new CentrifugeBlockEntity(blockPos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return !level.isClientSide() ? MathUtils.createTickerHelper(blockEntityType, ModBlockEntityTypes.CENTRIFUGE.get(), CentrifugeBlockEntity::serverTick) : null;
    }
}

