/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.container;

import com.ultramega.playershells.blockentities.ShellForgeBlockEntity;
import com.ultramega.playershells.container.ShellSlotItemHandler;
import com.ultramega.playershells.registry.ModBlocks;
import com.ultramega.playershells.registry.ModMenuTypes;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class ShellForgeContainerMenu
extends AbstractContainerMenu {
    private final ShellForgeBlockEntity blockEntity;
    private final ContainerLevelAccess access;

    public ShellForgeContainerMenu(int containerId, Inventory playerInventory, FriendlyByteBuf data) {
        this(containerId, playerInventory, ShellForgeContainerMenu.getBlockEntity(playerInventory, data), ContainerLevelAccess.NULL);
    }

    public ShellForgeContainerMenu(int containerId, Inventory playerInventory, ShellForgeBlockEntity blockEntity, ContainerLevelAccess access) {
        super(ModMenuTypes.SHELL_FORGE.get(), containerId);
        int i;
        this.blockEntity = blockEntity;
        this.access = access;
        this.addSlot((Slot)new ShellSlotItemHandler((IItemHandler)this.blockEntity.inventoryHandler, 0, 80, 17, this.blockEntity));
        InvWrapper itemHandler = new InvWrapper((Container)playerInventory);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, i, 8 + i * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack quickMovedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack rawStack = slot.getItem();
            quickMovedStack = rawStack.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(rawStack, 1, 36, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(rawStack, quickMovedStack);
            } else if (index >= 1 && index < 37 ? !this.moveItemStackTo(rawStack, 0, 1, false) && (index < 28 ? !this.moveItemStackTo(rawStack, 28, 37, false) : !this.moveItemStackTo(rawStack, 1, 28, false)) : !this.moveItemStackTo(rawStack, 1, 37, false)) {
                return ItemStack.EMPTY;
            }
            if (rawStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (rawStack.getCount() == quickMovedStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, rawStack);
        }
        return quickMovedStack;
    }

    public boolean stillValid(Player player) {
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.SHELL_FORGE.get()));
    }

    public ShellForgeBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    private static ShellForgeBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity blockEntity = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (blockEntity instanceof ShellForgeBlockEntity) {
            ShellForgeBlockEntity block = (ShellForgeBlockEntity)blockEntity;
            return block;
        }
        throw new IllegalStateException("Block entityType is not correct! " + String.valueOf(blockEntity));
    }
}

