/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultramega.playershells.blockentities.ShellForgeBlockEntity;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ShellButton
extends Button {
    private final ShellForgeBlockEntity shellForge;
    private int dotTick = 0;
    private int dotCount = 0;

    public ShellButton(int x, int y, int width, int height, Button.OnPress onPress, ShellForgeBlockEntity shellForge) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.shellForge = shellForge;
        this.tick();
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        graphics.setColor(1.0f, 0.0f, 0.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        graphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        String text = this.getMessage().getString();
        int color = this.getFGColor() | Mth.ceil((float)(this.alpha * 255.0f)) << 24;
        if (this.shellForge.getShellState() == ShellForgeBlockEntity.ShellStates.CREATING || this.shellForge.getShellState() == ShellForgeBlockEntity.ShellStates.EXTERMINATING) {
            int x = this.getX() + (this.getWidth() - mc.font.width(text.replace(".", ""))) / 2;
            int n = this.getY();
            int n2 = this.getHeight();
            Objects.requireNonNull(mc.font);
            int y = n + (n2 - 9) / 2 + 1;
            graphics.drawString(mc.font, text, x, y, color, true);
        } else {
            super.renderString(graphics, mc.font, color);
        }
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void setMessage(ShellForgeBlockEntity.ShellStates state) {
        String additional = state == ShellForgeBlockEntity.ShellStates.CREATING || state == ShellForgeBlockEntity.ShellStates.EXTERMINATING ? ".".repeat(this.dotCount) : "";
        super.setMessage((Component)Component.translatable((String)("gui.playershells.shell_forge." + state.name().toLowerCase(Locale.ROOT))).append(additional));
    }

    public void tick() {
        ShellForgeBlockEntity.ShellStates state = this.shellForge.getShellState();
        if (state == ShellForgeBlockEntity.ShellStates.CREATE) {
            this.active = this.shellForge.canCreateShell();
            this.resetDots();
        } else if (state == ShellForgeBlockEntity.ShellStates.CREATING || state == ShellForgeBlockEntity.ShellStates.EXTERMINATING) {
            this.active = false;
            if (++this.dotTick >= 10) {
                this.dotTick = 0;
                this.dotCount = (this.dotCount + 1) % 4;
            }
        } else {
            this.active = true;
            this.resetDots();
        }
        this.setMessage(state);
    }

    private void resetDots() {
        this.dotTick = 0;
        this.dotCount = 0;
    }
}

